<?php

namespace App\Traits;

use App\Models\Payment;
use App\Models\Rent;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

trait HasDashboard
{
    public static function getAllRentAmount()
    {
        return Rent::sum('rent_amount');
    }
    public function getAllTotalPayments()
    {
        return Payment::sum('amount');
    }
    public function  getMonthlyRentCollectionTrendChart()
    {
        $monthlyRentCollection = Payment::whereHas('contract', fn($q) => $q->where('status', 1))
            ->select(
                DB::raw('YEAR(created_at) as year'),
                DB::raw('MONTH(created_at) as month'),
                DB::raw('SUM(amount) as total')
            )
            ->groupBy('year', 'month')
            ->orderBy('year', 'asc')
            ->orderBy('month', 'asc')
            ->get();
        return  $rentChartData = [
            'categories' => $monthlyRentCollection->map(function ($item) {
                return Carbon::create($item->year, $item->month)->format('M Y');
            })->toArray(),
            'series' => [
                [
                    'name' => 'Rent Collected',
                    'data' => $monthlyRentCollection->pluck('total')->toArray()
                ]
            ]
        ];
    }
}
