<?php

namespace App\Traits;

use Abivia\Ledger\Http\Controllers\LedgerAccountController;
use Abivia\Ledger\Messages\Account;
use Abivia\Ledger\Messages\Create;
use Exception;
use Illuminate\Support\Facades\Log;
use Abivia\Ledger\Ledger;
use Abivia\Ledger\Messages\AccountAdd;

trait HasLedgerAccount
{
    public function createLedgerAccount(): void
    {
        if ($this->ledger_reference_uuid) {
            return; // Already created
        }

        $code = 'AGENT-' . strtoupper($this->code);   // e.g., AGENT-ALEPPO001

        $message = new Account();
        $message->code = $code;
        $message->name = $this->name . ' Cash Account';
        $message->debit = true;  // Cash account is a debit account

        $response = (new LedgerAccountController())->run($message);

        $this->ledger_reference_uuid = $response->account->ledgerUuid;
        $this->save();
    }

    protected function createCashAccount(): string
    {
        $account = new Account();
        $account->code = $this->generateCashAccountCode();
        $account->name = "Cash Account - {$this->name}";
        $account->debit = true;
        $account->parentCode = '1000';

        return $this->createLedgerAccount($account);
    }

    protected function createLiabilityAccount(): string
    {
        $account = new Account();
        $account->code = $this->generateLiabilityAccountCode();
        $account->name = "Liability Account - {$this->name}";
        $account->credit = true;
        $account->parentCode = '2000';

        return $this->createLedgerAccount($account);
    }


    protected function generateCashAccountCode(): string
    {
        return '11' . str_pad($this->id, 3, '0', STR_PAD_LEFT);
    }

    protected function generateLiabilityAccountCode(): string
    {
        return '21' . str_pad($this->id, 3, '0', STR_PAD_LEFT);
    }
}
