<?php

namespace App\Traits;

trait InvoiceData
{
    /**
     * Get the necessary invoice data.
     *
     * @return array
     */
    public function getInvoiceData(): array
    {
        // Customize the data based on the model
        return [
            'id' => $this->id,
            'description' => $this->description ?? '-',
            'amount' => $this->amount,
            'date' => $this->created_at->format('Y-m-d'),
            'items' => $this->items, // If you have items as a relationship
            'totalAmount' => $this->totalAmount ?? $this->amount, // Customize as needed
        ];
    }
}
