<?php

namespace App\View\Components;

use App\Models\Currency;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class CurrencyAvatar extends Component
{
    public $currency;
    public $size;
    public $avatar;

    public function __construct($currency, $size = 24)
    {
        $currency = Currency::where('code', $currency)->first();
        $avatar = $currency->getAvatar();
        $this->avatar = $avatar;

        $this->size = $size;
    }


    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.currency-avatar');
    }
}
