<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Agent;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Agent>
 */
class AgentFactory extends Factory
{
    protected $model = Agent::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->company,
            'code' => strtoupper($this->faker->unique()->bothify('AGT###')), // e.g. AGT123
            'phone' => $this->faker->phoneNumber,
            'email' => $this->faker->unique()->safeEmail,
            'username' => $this->faker->unique()->userName,
            'password' => bcrypt('password'), // default password
            'ledger_reference_uuid' => null,
            'user_id' => null, // or factory(User::class) if you want to link
            'is_active' => $this->faker->boolean(90), // 90% active by default
            'settings' => null, // you can json encode some settings if needed
            'credit_limit' => $this->faker->randomFloat(2, 0, 100000), // random credit limit 0-100,000
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
