<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Client;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Client>
 */
class ClientFactory extends Factory
{
    protected $model = Client::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->name,
            'place_of_birth' => $this->faker->city,
            'date_of_birth' => $this->faker->date(),
            'gender' => $this->faker->randomElement(['male', 'female']),
            'mother_name' => $this->faker->name('female'),
            'father_name' => $this->faker->name('male'),
            'nationality' => $this->faker->country,
            'phone' => $this->faker->phoneNumber,
            'mobile' => $this->faker->phoneNumber,
            'identity_type' => $this->faker->randomElement([1, 2, 3]), // 1=national_id, 2=passport, 3=driving_license
            'identity_number' => $this->faker->unique()->numerify('##########'),
            'job' => $this->faker->jobTitle,
            'notes' => $this->faker->optional()->sentence,
            'type' => $this->faker->randomElement([1, 2]), // 1=individual, 2=company
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
