<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Currency;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Currency>
 */
class CurrencyFactory extends Factory
{
  protected $model = Currency::class;

  public function definition(): array
  {
    $currencies = [
      ['code' => 'USD', 'name' => 'US Dollar', 'symbol' => '$'],
      ['code' => 'EUR', 'name' => 'Euro', 'symbol' => '€'],
      ['code' => 'TRY', 'name' => 'Turkish Lira', 'symbol' => '₺'],
      ['code' => 'GBP', 'name' => 'British Pound', 'symbol' => '£'],
      ['code' => 'SYP', 'name' => 'Syrian Pound', 'symbol' => '£S'],
    ];

    $currency = $this->faker->randomElement($currencies);

    return [
      'code' => $currency['code'],
      'name' => $currency['name'],
      'symbol' => $currency['symbol'],
                  'exchange_rate' => $this->faker->randomFloat(4, 0.1, 100),
      'created_at' => now(),
      'updated_at' => now(),
    ];
  }

  public function usd(): static
  {
    return $this->state(fn(array $attributes) => [
      'code' => 'USD',
      'name' => 'US Dollar',
      'symbol' => '$',
      'exchange_rate' => 1.0000,
    ]);
  }

  public function try(): static
  {
    return $this->state(fn(array $attributes) => [
      'code' => 'TRY',
      'name' => 'Turkish Lira',
      'symbol' => '₺',
                  'exchange_rate' => 30.0000,
    ]);
  }
}
