<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agents', function (Blueprint $table) {
            $table->id();
            // Core identity
            $table->string('name');                         // Agent name (branch or franchise)
            $table->string('code')->unique();               // Internal unique identifier, e.g. ALEPPO001
            $table->string("phone")->nullable();
            $table->string("email")->nullable();
            $table->string("username")->nullable();
            $table->string("password")->nullable();
            $table->uuid('ledger_reference_uuid')->nullable();

            // Optional user link (e.g., franchise admin)
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();

            // Status & metadata
            $table->boolean('is_active')->default(true);
            $table->json('settings')->nullable();          // Optional: working hours, cash limits, etc.
            $table->decimal('credit_limit', 15, 2)->default(0);
            $table->timestamps();
        });

        Schema::create('ledger_entities', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // 'agent', 'category', 'expense', etc.
            $table->string('name'); // e.g., 'Aleppo Agent', 'Employee Salaries'
            $table->string('code')->unique(); // e.g., 'AG-ALEPPO', 'EXP-SALARY'
            $table->uuid('ledger_account_code'); // Abivia account link
            $table->nullableMorphs('entityable'); // links to agents, customers, banks, etc.
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ledger_entities');
        Schema::dropIfExists('agents');
    }
};
