<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ledger_transfers', function (Blueprint $table) {
            $table->uuid('debit_journal_uuid')->nullable();   // For the sender
            $table->uuid('credit_journal_uuid')->nullable();  // For the receiver
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ledger_transfers', function (Blueprint $table) {
            $table->dropColumn('debit_journal_uuid');
            $table->dropColumn('credit_journal_uuid');
        });
    }
};
