<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->json('name');
            $table->string("place_of_birth")->nullable();
            $table->string("date_of_birth")->nullable();
            $table->enum("gender", ["male", "female"])->default("male");
            $table->string("mother_name")->nullable();
            $table->string("nationality")->nullable();
            $table->string("phone")->nullable();
            $table->string("mobile")->nullable();
            $table->integer("identity_type")->default(1);
            $table->string("identity_number")->nullable();
            $table->string("job")->nullable();
            $table->string("notes")->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
