<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->id();
            $table->json('name');
            $table->string('code');
            $table->string('symbol')->nullable();
            $table->string("color")->nullable();
            $table->boolean("is_default")->default(false);
            $table->float("exchange_rate")->default(1);
            $table->enum("rate_factor", ["multiply", "divide"])->default("multiply");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currencies');
    }
};
