<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transfer_packages', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('type')->default('transfer');
            $table->string('currency', 3)->default('USD');
            $table->foreignId("agent_id")->nullable()->constrained('agents')->onDelete('set null');
            $table->timestamps();

            // Optional: index for 'type' if queried often
            // $table->index('type');
        });

        Schema::create('transfer_packages_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('package_id')->constrained('transfer_packages')->onDelete('cascade');
            $table->decimal('min_amount', 12, 2);
            $table->decimal('max_amount', 12, 2);
            $table->decimal('send_fee', 12, 2);
            $table->decimal('receive_fee', 12, 2);
            $table->decimal('another_fee', 12, 2)->nullable();
            $table->timestamps();
        });

        Schema::create('agents_transfer_packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('package_id')->constrained('transfer_packages')->onDelete('cascade');
            $table->foreignId('agent_id')->constrained('agents')->onDelete('cascade');
            $table->timestamps();

            // Optional: Add unique constraint if you want to prevent duplicate pairs
            // $table->unique(['package_id', 'agent_id']);
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transfer_packages_details');
        Schema::dropIfExists('agents_transfer_packages');
        Schema::dropIfExists('transfer_packages');
    }
};
