<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transfer_packages_details', function (Blueprint $table) {
            $table->enum('send_fee_type', ['fixed', 'percent'])->default('fixed');
            $table->enum('receive_fee_type', ['fixed', 'percent'])->default('fixed');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transfer_packages_details', function (Blueprint $table) {
            $table->dropColumn('send_fee_type');
            $table->dropColumn('receive_fee_type');
        });
    }
};
