<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ledger_transfers', function (Blueprint $table) {
            $table->boolean('is_collected')->default(false);
            $table->boolean("is_paid")->default(false);
            $table->index('is_collected');
            $table->index('is_paid');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ledger_transfers', function (Blueprint $table) {
            $table->dropIndex(['is_collected']);
            $table->dropIndex(['is_paid']);
            $table->dropColumn("is_collected");
            $table->dropColumn("is_paid");
        });
    }
};
