<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::table('addresses', function (Blueprint $table) {
      // Add indexes for commonly searched fields
      $table->index('country', 'idx_addresses_country');
      $table->index('city', 'idx_addresses_city');

      // Composite index for polymorphic relationship + country searches
      $table->index(['addressable_type', 'addressable_id', 'country'], 'idx_addresses_polymorphic_country');

      // Composite index for polymorphic relationship + city searches
      $table->index(['addressable_type', 'addressable_id', 'city'], 'idx_addresses_polymorphic_city');

      // Composite index for country + city searches
      $table->index(['country', 'city'], 'idx_addresses_country_city');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::table('addresses', function (Blueprint $table) {
      $table->dropIndex('idx_addresses_country');
      $table->dropIndex('idx_addresses_city');
      $table->dropIndex('idx_addresses_polymorphic_country');
      $table->dropIndex('idx_addresses_polymorphic_city');
      $table->dropIndex('idx_addresses_country_city');
    });
  }
};
