<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Facades\Schema;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();

        // Create Roles
        $super_admin = Role::create(['name' => 'super admin']);
        $admin = Role::create(['name' => 'administrator']);
        $manager = Role::create(['name' => 'manager']);
        $executive = Role::create(['name' => 'executive']);
        $user = Role::create(['name' => 'user']);

        $data = [

            ///////////////Admin/////////
            [
                'name' => 'edit Admins',
                'guard_name' => 'web',
                'tree_id' => 1
            ],
            [
                'name' => 'add admins',
                'guard_name' => 'web',
                'tree_id' => 1
            ],
            [
                'name' => 'delete admins',
                'guard_name' => 'web',
                'tree_id' => 1
            ],
            [
                'name' => 'view admins',
                'guard_name' => 'web',
                'tree_id' => 1
            ],
            [
                'name' => 'View Roles',
                'guard_name' => 'web',
                'tree_id' => 1
            ],
            //////////////////////CRM////////////////
            [
                'name' => 'list agents',
                'guard_name' => 'web',
                'tree_id' => 2
            ],
            [
                'name' => 'add agents',
                'guard_name' => 'web',
                'tree_id' => 2
            ],
            [
                'name' => 'edit agents',
                'guard_name' => 'web',
                'tree_id' => 2
            ],
            [
                'name' => 'delete agents',
                'guard_name' => 'web',
                'tree_id' => 2
            ],
            [
                'name' => 'set agents revenue',
                'guard_name' => 'web',
                'tree_id' => 2
            ],
            [
                'name' => 'branch managment',
                'guard_name' => 'web',
                'tree_id' => 2
            ],


            //////////////////Customers/////////////////
            [
                'name' => 'add customers',
                'guard_name' => 'web',
                'tree_id' => 3
            ],
            [
                'name' => 'delete customers',
                'guard_name' => 'web',
                'tree_id' => 3
            ],
            [
                'name' => 'edit customers',
                'guard_name' => 'web',
                'tree_id' => 3
            ],
            [
                'name' => 'List customers',
                'guard_name' => 'web',
                'tree_id' => 3
            ],
            /////////////////////Transfers/////
            [
                'name' => 'add transfer',
                'guard_name' => 'web',
                'tree_id' => 4
            ],
            [
                'name' => 'deliver transfer',
                'guard_name' => 'web',
                'tree_id' => 4
            ],
            [
                'name' => 'edit transfer',
                'guard_name' => 'web',
                'tree_id' => 4
            ],
            [
                'name' => 'delete transfer',
                'guard_name' => 'web',
                'tree_id' => 4
            ],
            [
                'name' => 'view recipets',
                'guard_name' => 'web',
                'tree_id' => 4
            ],
            [
                'name' => 'view transfers',
                'guard_name' => 'web',
                'tree_id' => 4
            ],
            ////////////////////Plan Permissions///
            [
                'name' => 'view bookings',
                'guard_name' => 'web',
                'tree_id' => 5
            ],
            [
                'name' => 'add bookings',
                'guard_name' => 'web',
                'tree_id' => 5
            ],
            [
                'name' => 'edit bookings',
                'guard_name' => 'web',
                'tree_id' => 5
            ],
            [
                'name' => 'delete bookings',
                'guard_name' => 'web',
                'tree_id' => 5
            ],
            [
                'name' => 'view booking receipts',
                'guard_name' => 'web',
                'tree_id' => 5
            ],



            //////////////////////////Locations////////////////
            [
                'name' => 'view exchanges',
                'guard_name' => 'web',
                'tree_id' => 6
            ],
            [
                'name' => 'add exchanges',
                'guard_name' => 'web',
                'tree_id' => 6
            ],
            [
                'name' => 'edit exchanges',
                'guard_name' => 'web',
                'tree_id' => 6
            ],
            [
                'name' => 'delete exchanges',
                'guard_name' => 'web',
                'tree_id' => 6
            ],
            [
                'name' => 'view exchanges receipts',
                'guard_name' => 'web',
                'tree_id' => 6
            ],
            //////////////////////////////Config/////////
            [
                'name' => 'view credits config',
                'guard_name' => 'web',
                'tree_id' => 7
            ],
            [
                'name' => 'edit credits config',
                'guard_name' => 'web',
                'tree_id' => 7
            ],

            /////////////////////////////customers///////////
            [
                'name' => 'view  payments',
                'guard_name' => 'web',
                'tree_id' => 8
            ],
            [
                'name' => 'edit payments',
                'guard_name' => 'web',
                'tree_id' => 8
            ],
            [
                'name' => 'delete payments',
                'guard_name' => 'web',
                'tree_id' => 8
            ],



            /////////////////////////Bandwidth///////////////
            [
                'name' => 'view collections',
                'guard_name' => 'web',
                'tree_id' => 9
            ],
            [
                'name' => 'add collections',
                'guard_name' => 'web',
                'tree_id' => 9
            ],
            [
                'name' => 'delete collections',
                'guard_name' => 'web',
                'tree_id' => 9
            ],

            //////////////////////////Approval///////////
            [
                'name' => 'view approvals',
                'guard_name' => 'web',
                'tree_id' => 10
            ],
            [
                'name' => 'add approvals',
                'guard_name' => 'web',
                'tree_id' => 10
            ],
            [
                'name' => 'delete approvals',
                'guard_name' => 'web',
                'tree_id' => 10
            ],
            [
                'name' => 'edit approvals',
                'guard_name' => 'web',
                'tree_id' => 10
            ],
            //////////////Packages////////////////////
            [
                'name' => 'view packages',
                'guard_name' => 'web',
                'tree_id' => 11
            ],
            [
                'name' => 'add packages',
                'guard_name' => 'web',
                'tree_id' => 11
            ],
            [
                'name' => 'edit packages',
                'guard_name' => 'web',
                'tree_id' => 11
            ],
            [
                'name' => 'delete packages',
                'guard_name' => 'web',
                'tree_id' => 11
            ],
            ///////////////Exchange Prices/////////
            [
                'name' => 'view exchange prices',
                'guard_name' => 'web',
                'tree_id' => 12
            ],
            [
                'name' => 'add exchange prices',
                'guard_name' => 'web',
                'tree_id' => 12
            ],
            [
                'name' => 'edit exchange prices',
                'guard_name' => 'web',
                'tree_id' => 12
            ],
            [
                'name' => 'delete exchange prices',
                'guard_name' => 'web',
                'tree_id' => 12
            ],
            //////////////Reseller/////////

            [
                'name' => 'view accounts',
                'guard_name' => 'web',
                'tree_id' => 13
            ],
            [
                'name' => 'hide/show accounts',
                'guard_name' => 'web',
                'tree_id' => 13
            ],
            [
                'name' => 'view statements',
                'guard_name' => 'web',
                'tree_id' => 13
            ],
            [
                'name' => 'view currency positions',
                'guard_name' => 'web',
                'tree_id' => 13
            ],

            //////////////////////currencies//////////

            [
                'name' => 'add currency',
                'guard_name' => 'web',
                'tree_id' => 14
            ],
            [
                'name' => 'edit currency',
                'guard_name' => 'web',
                'tree_id' => 14
            ],
            [
                'name' => 'delete currency',
                'guard_name' => 'web',
                'tree_id' => 14
            ],







        ];
        foreach ($data as $permission) {
            Permission::firstorcreate($permission);
        }
    }
}
