<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('users')->insert([
            'name' => 'Super Admin',
            'firstname' => 'Super',
            'lastname' => 'Admin',
            'gender' => 'm',
            //  'code' => 'SUPER' . Str::random(5),
            'email' => 'super@admin.com',
            'email_verified_at' => now(),
            'password' => Hash::make('password'),
            'two_factor_secret' => null,
            'two_factor_recovery_codes' => null,
            'two_factor_confirmed_at' => null,
            'remember_token' => Str::random(10),
            'current_team_id' => null,
            'profile_photo_path' => null,
            'phone' => '1234567890',
            'parent_id' => null,
            'portal_access' => 1, // Assuming 1 means full access
            'status' => 1, // Active
            'created_at' => now(),
            'updated_at' => now(),
            'id_number' => 'ADMIN' . Str::random(5),
        ]);
    }
}
