/**
 *  Logistics Dashboard
 */

(function () {
  let borderColor, labelColor, headingColor, legendColor;
  let BudgetChart;
  let CategoryChart;
  let CashFlowChart;
  let propertyTypeChart;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }

  // Chart Colors
  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger,
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: '#7367f029'
    }
  };

  window.addEventListener('MonthlyDistributionChartUpdated', function (event) {
    const data = event.detail[0].data;
    InitMonthlyDistributionChart(data.series, data.categories);
  });

  function InitMonthlyDistributionChart(series, categories) {
    const allValues = series.flatMap(s => s.data);
    const maxValue = Math.max(...allValues);
    const yAxisMax = Math.ceil((maxValue * 1.2) / 10000) * 10000;
    const chartEl = document.querySelector('#monthlyDistributionChart');
    const chartConfig = {
      series: series,
      chart: {
        height: 320,
        type: 'line',
        stacked: false,
        parentHeightOffset: 0,
        toolbar: { show: false },
        zoom: { enabled: false }
      },
      markers: {
        size: 5,
        colors: [config.colors.white],
        strokeColors: chartColors.line.series2,
        hover: { size: 6 },
        borderRadius: 4
      },
      stroke: {
        curve: 'smooth',
        width: [0, 3],
        lineCap: 'round'
      },
      legend: {
        show: true,
        position: 'bottom',
        markers: {
          width: 8,
          height: 8,
          offsetX: -3
        },
        height: 40,
        itemMargin: {
          horizontal: 10,
          vertical: 0
        },
        fontSize: '15px',
        fontFamily: 'Public Sans',
        fontWeight: 400,
        labels: {
          colors: headingColor,
          useSeriesColors: false
        },
        offsetY: 10
      },
      grid: {
        strokeDashArray: 8,
        borderColor
      },
      colors: [chartColors.line.series1, chartColors.line.series2],
      fill: {
        opacity: [1, 1]
      },
      plotOptions: {
        bar: {
          columnWidth: '30%',
          startingShape: 'rounded',
          endingShape: 'rounded',
          borderRadius: 4
        }
      },
      dataLabels: { enabled: false },
      xaxis: {
        tickAmount: 10,
        categories: categories,
        labels: {
          style: {
            colors: labelColor,
            fontSize: '13px',
            fontWeight: 400
          }
        },
        axisBorder: { show: false },
        axisTicks: { show: false }
      },
      yaxis: {
        min: 0,
        max: yAxisMax,
        tickAmount: 5,
        labels: {
          formatter: function (val) {
            return val.toLocaleString() + ' ₺';
          }
        }
      },
      responsive: [
        {
          breakpoint: 1400,
          options: {
            chart: { height: 320 },
            xaxis: { labels: { style: { fontSize: '10px' } } },
            legend: {
              itemMargin: {
                vertical: 0,
                horizontal: 10
              },
              fontSize: '13px',
              offsetY: 12
            }
          }
        },
        {
          breakpoint: 1025,
          options: {
            chart: { height: 415 },
            plotOptions: { bar: { columnWidth: '50%' } }
          }
        },
        {
          breakpoint: 982,
          options: { plotOptions: { bar: { columnWidth: '30%' } } }
        },
        {
          breakpoint: 480,
          options: {
            chart: { height: 250 },
            legend: { offsetY: 7 }
          }
        }
      ]
    };

    if (chartEl) {
      new ApexCharts(chartEl, chartConfig).render();
    }
  }
  window.addEventListener('GenderDistributionChartUpdated', function (event) {
    const data = event.detail[0].data;
    InitGenderDistributionChart(data.series, data.labels);
  });

  function InitGenderDistributionChart(series, labels) {
    const chartEl = document.querySelector('#genderDistributionChart');

    const chartConfig = {
      chart: {
        type: 'donut',
        height: 320
      },
      labels: labels,
      series: series,
      colors: ['#7367F0', '#EA5455'], // male, female
      legend: {
        position: 'bottom'
      },
      dataLabels: {
        enabled: true,
        formatter: val => val.toFixed(1) + '%'
      },
      tooltip: {
        y: {
          formatter: val => val.toLocaleString()
        }
      }
    };

    if (chartEl) {
      new ApexCharts(chartEl, chartConfig).render();
    }
  }
  window.addEventListener('EvlatShareChartUpdated', function (event) {
    const data = event.detail[0].data;
    InitEvlatShareChart(data.series, data.labels);
  });

  function InitEvlatShareChart(series, labels) {
    const chartEl = document.querySelector('#evlatShareChart');

    const chartConfig = {
      chart: {
        type: 'bar',
        height: 400
      },
      series: [
        {
          name: 'Total Received',
          data: series
        }
      ],
      xaxis: {
        categories: labels,
        labels: {
          style: { fontSize: '13px' }
        }
      },
      colors: ['#28C76F'],
      plotOptions: {
        bar: {
          horizontal: true
        }
      },
      tooltip: {
        y: {
          formatter: val => val.toLocaleString() + ' ₺'
        }
      }
    };

    if (chartEl) {
      new ApexCharts(chartEl, chartConfig).render();
    }
  }
  window.addEventListener('EvlatWithdrawalsChartUpdated', function (event) {
    const data = event.detail[0].data;
    InitEvlatWithdrawalsChart(data.series, data.categories);
  });

  function InitEvlatWithdrawalsChart(series, categories) {
    const chartEl = document.querySelector('#evlatWithdrawalsChart');
    if (!chartEl) return;

    const chart = new ApexCharts(chartEl, {
      chart: {
        type: 'line',
        height: 320,
        toolbar: { show: true }
      },
      series: series,
      xaxis: {
        categories: categories
      },
      yaxis: {
        labels: {
          formatter: val => val.toLocaleString() + ' ₺'
        }
      },
      tooltip: {
        y: {
          formatter: val => val.toLocaleString() + ' ₺'
        }
      },
      stroke: { curve: 'smooth', width: 2 },
      markers: { size: 4 }
    });

    chart.render();
  }
  window.addEventListener('EvlatWithdrawalsChartUpdated', function (event) {
    const data = event.detail[0].data;
    InitEvlatWithdrawalsChart(data.series, data.categories);
  });
  window.addEventListener('DistributionByGenderAndDateUpdated', function (event) {
    const data = event.detail[0].data;
    InitDistributionByGenderAndDateChart(data.male, data.female, data.labels);
  });
  function InitDistributionByGenderAndDateChart(maleSeries, femaleSeries, labels) {
    const chartEl = document.querySelector('#distributionByGenderAndDateChart');
    if (!chartEl) return;
    const chart = new ApexCharts(chartEl, {
      chart: {
        type: 'bar',
        height: 320,
        toolbar: { show: true }
      },
      series: [
        {
          name: 'Male',
          data: maleSeries
        },
        {
          name: 'Female',
          data: femaleSeries
        }
      ],
      xaxis: {
        categories: labels
      },
      yaxis: {
        labels: {
          formatter: val => val.toLocaleString() + ' ₺'
        }
      },
      tooltip: {
        y: {
          formatter: val => val.toLocaleString() + ' ₺'
        }
      },
      stroke: { curve: 'smooth', width: 2 },
      markers: { size: 4 }
    });
    chart.render();
  }

  window.addEventListener('WithdrawVsBalanceChartUpdated', function (event) {
    const data = event.detail[0].data;
    const chart = new ApexCharts(document.querySelector('#withdrawVsBalanceChart'), {
      chart: {
        type: 'donut',
        height: 320
      },
      series: data.series,
      labels: data.labels,
      colors: ['#00CFE8', '#7367F0'],
      dataLabels: { enabled: true },
      tooltip: {
        y: {
          formatter: val => val.toLocaleString('tr-TR') + ' ₺'
        }
      }
    });
    chart.render();
  });
  window.addEventListener('filtersApplied', function (event) {
    const data = event.detail[0];
    console.log(data);
    let table = window.LaravelDataTables['budget-table'];
    if (table) {
      // Stringify the filters object before storing
      window.filters = JSON.parse(JSON.stringify(data.filters));

      // Force a full reload
      table.ajax.reload();
    }
    table = window.LaravelDataTables['charity-table'];
    if (table) {
      // Stringify the filters object before storing
      window.filters = JSON.parse(JSON.stringify(data.filters));

      // Force a full reload
      table.ajax.reload();
    }
  });
  $('body').on('click', '#add-evlat-button', function (e) {
    e.preventDefault();

    $('#addEvlatModal').modal('show');
  });
})();
