/**
 *  Pages User Profile (jquery)
 */

'use strict';

(function () {
  let monthlyChart;
  let propertyTypeChart;
  let maintenanceCostChart;
  let topPropertiesChart;
  let OccupancyChart;
  let dt_properties;
  let borderColor, labelColor, headingColor, legendColor;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }

  // Chart Colors
  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger,
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: '#7367f029'
    }
  };
  //  Projects table
  var dt_properties_table = $('.datatables-properties');
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });
  const flatpickrDate = $('.flatpickrDate');

  flatpickrDate.flatpickr({
    monthSelectorType: 'static'
  });

  function initDataTable() {
    dt_properties = dt_properties_table.DataTable({
      serverSide: true,
      processing: true,
      ajax: {
        url: dt_properties_table.data('ajax'),
        data: {
          portfolio_id: dt_properties_table.data('portfolio-id')
        },
        type: 'GET'
      },
      columns: [
        { data: 'id' },
        { data: 'independent_unit_no' },
        { data: 'qualification' },
        { data: 'type' },
        { data: 'usage_type' },
        { data: 'rent_status' },

        { data: 'net_sqm' },
        { data: 'gross_sqm' },
        { data: 'rent_price' },
        { data: 'is_active' }
      ],
      columnDefs: [
        {
          // For Responsive
          className: 'control',
          searchable: false,
          orderable: false,
          responsivePriority: 2,
          targets: 0,
          render: function (data, type, full, meta) {
            return '';
          }
        },
        {
          // For Checkboxes
          targets: 1,
          orderable: false,
          searchable: false,
          responsivePriority: 3,
          checkboxes: true,
          render: function () {
            return '<input type="checkbox" class="dt-checkboxes form-check-input">';
          },
          checkboxes: {
            selectAllRender: '<input type="checkbox" class="form-check-input">'
          }
        }
      ],
      order: [[2, 'desc']],
      dom: '<"card-header flex-column flex-md-row"<"head-label text-center"><"dt-action-buttons text-end pt-6 pt-md-0"B>><"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end mt-n6 mt-md-0"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
      displayLength: 7,
      lengthMenu: [7, 10, 25, 50, 75, 100],
      language: {
        search: '',
        searchPlaceholder: 'Search Project',
        paginate: {
          next: '<i class="ti ti-chevron-right ti-sm"></i>',
          previous: '<i class="ti ti-chevron-left ti-sm"></i>'
        }
      },
      responsive: {
        details: {
          display: $.fn.dataTable.Responsive.display.modal({
            header: function (row) {
              var data = row.data();
              return 'Details of "' + data['project_name'] + '" Project';
            }
          }),
          type: 'column',
          renderer: function (api, rowIdx, columns) {
            var data = $.map(columns, function (col, i) {
              return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                ? '<tr data-dt-row="' +
                    col.rowIndex +
                    '" data-dt-column="' +
                    col.columnIndex +
                    '">' +
                    '<td>' +
                    col.title +
                    ':' +
                    '</td> ' +
                    '<td>' +
                    col.data +
                    '</td>' +
                    '</tr>'
                : '';
            }).join('');

            return data ? $('<table class="table"/><tbody />').append(data) : false;
          }
        }
      },
      buttons: [
        {
          text: '<i class="ti ti-plus me-sm-1"></i> <span class="d-none d-sm-inline-block">Add</span>',
          className: 'create-new btn btn-primary waves-effect waves-light',
          attr: {
            'data-bs-toggle': 'modal',
            'data-bs-target': '#addNewProperty'
          }
        }
      ]
    });
    $('div.head-label').html('<h5 class="card-title mb-0">Property List</h5>');
  }

  initDataTable();
  window.addEventListener('refreshDataTable', function (e) {
    // if ($.fn.DataTable.isDataTable(dt_properties_table)) {
    //   dt_properties_table.DataTable().clear().destroy();
    // }
    initDataTable();
  });

  // Filter form control to default size
  // ? setTimeout used for multilingual table initialization
  setTimeout(() => {
    $('.dataTables_filter .form-control').removeClass('form-control-sm');
    $('.dataTables_length .form-select').removeClass('form-select-sm');
  }, 300);

  window.addEventListener('OccupancyPieChartDataUpdated', function (event) {
    console.log(event);
    var series = event.detail[0].data.series;
    var labels = event.detail[0].data.labels;
    console.log(event);
    initOccupancyChart(labels, series);
  });
  function initOccupancyChart(labels, series) {
    // Reasons for delivery exceptions Chart
    // --------------------------------------------------------------------
    const OccupancyChartE1 = document.querySelector('#OccupancyChart'),
      OccupancyChartConfig = {
        chart: {
          height: 420,
          parentHeightOffset: 0,
          type: 'donut'
        },
        labels: labels,
        series: series,
        colors: [
          chartColors.donut.series1,
          chartColors.donut.series2,
          chartColors.donut.series3,
          chartColors.donut.series4
        ],
        stroke: {
          width: 0
        },
        dataLabels: {
          enabled: false,
          formatter: function (val, opt) {
            return parseInt(val);
          }
        },
        legend: {
          show: true,
          position: 'bottom',
          offsetY: 10,
          markers: {
            width: 8,
            height: 8,
            offsetX: -3
          },
          itemMargin: {
            horizontal: 15,
            vertical: 5
          },
          fontSize: '13px',
          fontFamily: 'Public Sans',
          fontWeight: 400,
          labels: {
            colors: headingColor,
            useSeriesColors: false
          }
        },
        tooltip: {
          theme: false
        },
        grid: {
          padding: {
            top: 15
          }
        },
        plotOptions: {
          pie: {
            donut: {
              size: '77%',
              labels: {
                show: true,
                value: {
                  fontSize: '24px',
                  fontFamily: 'Public Sans',
                  color: headingColor,
                  fontWeight: 500,
                  offsetY: -20,
                  formatter: function (val) {
                    return parseInt(val);
                  }
                },
                name: {
                  offsetY: 30,
                  fontFamily: 'Public Sans'
                },
                total: {
                  show: true,
                  fontSize: '15px',
                  fontFamily: 'Public Sans',
                  color: legendColor,

                  formatter: function (w) {
                    return parseInt(w.globals.seriesTotals.reduce((a, b) => a + b, 0));
                  }
                }
              }
            }
          }
        },
        responsive: [
          {
            breakpoint: 420,
            options: {
              chart: {
                height: 360
              }
            }
          }
        ]
      };
    if (!OccupancyChart) {
      OccupancyChart = new ApexCharts(OccupancyChartE1, OccupancyChartConfig);
      OccupancyChart.render();
    } else {
      OccupancyChart.updateOptions(OccupancyChartConfig);
    }
  }
  window.addEventListener('MonthlyRentCollectionChartDataUpdated', function (event) {
    var monthlyChartE1 = document.querySelector('#RentalCollectionChart');
    var data = event.detail[0].data;
    console.log(data);
    var monthlyChartConfig = {
      chart: {
        type: 'bar',
        stacked: true,
        height: 400
      },
      colors: ['#1E90FF', '#FFA500'], // blue, orange-red
      series: data.series,
      xaxis: {
        categories: data.labels
      },
      plotOptions: {
        bar: {
          horizontal: false,

          endingShape: 'rounded'
        }
      },
      dataLabels: {
        enabled: false
      },
      stroke: {
        show: true,
        width: 2,
        colors: ['transparent']
      },
      tooltip: {
        y: {
          formatter: function (val) {
            return '₺' + val.toLocaleString();
          }
        }
      }
    };

    if (!monthlyChart) {
      monthlyChart = new ApexCharts(monthlyChartE1, monthlyChartConfig);
      monthlyChart.render();
    } else {
      monthlyChart.updateOptions(monthlyChartConfig);
    }
  });
  window.addEventListener('PropertyTypeChartDataUpdated', function (event) {
    var propertyTypeChartE1 = document.querySelector('#property-type-chart');
    var data = event.detail[0].data;
    var propertyTypeChartConfig = {
      chart: {
        type: 'bar',
        height: 400
      },
      colors: ['#34A853', '#FB8C00'], // Green for count, Orange for rent
      series: data.series,
      xaxis: {
        categories: data.labels
      },
      plotOptions: {
        bar: {
          horizontal: false,
          columnWidth: '50%',
          endingShape: 'rounded'
        }
      },
      dataLabels: {
        enabled: true
      },
      tooltip: {
        y: {
          formatter: function (val, opts) {
            let seriesName = opts.seriesIndex === 0 ? ' properties' : ' rent';
            return val + seriesName;
          }
        }
      }
    };
    if (!propertyTypeChart) {
      propertyTypeChart = new ApexCharts(propertyTypeChartE1, propertyTypeChartConfig);
      propertyTypeChart.render();
    } else {
      propertyTypeChart.updateOptions(propertyTypeChartConfig);
    }
  });
  window.addEventListener('MaintenanceCostChartDataUpdated', function (event) {
    if (maintenanceCostChart) maintenanceCostChart.destroy();

    const data = event.detail[0].data;

    maintenanceCostChart = new ApexCharts(document.querySelector('#maintenance-cost-chart'), {
      chart: {
        type: 'bar',
        height: 400
      },
      colors: ['#1E88E5'],
      series: data.series,
      xaxis: {
        categories: data.labels
      },
      plotOptions: {
        bar: {
          columnWidth: '50%',
          endingShape: 'rounded'
        }
      },
      dataLabels: {
        enabled: true,
        formatter: function (val) {
          return '₺' + val.toLocaleString();
        }
      },
      tooltip: {
        y: {
          formatter: function (val) {
            return '₺' + val.toLocaleString();
          }
        }
      }
    });

    maintenanceCostChart.render();
  });
  window.addEventListener('TopPropertiesByIncomeChartUpdated', function (event) {
    if (topPropertiesChart) topPropertiesChart.destroy();

    const data = event.detail[0].data;

    topPropertiesChart = new ApexCharts(document.querySelector('#top-properties-income-chart'), {
      chart: {
        type: 'bar',
        height: 400
      },
      series: [
        {
          name: 'Total Income',
          data: data.series
        }
      ],
      xaxis: {
        categories: data.labels
      },
      colors: ['#00C49F'],
      plotOptions: {
        bar: {
          columnWidth: '50%',
          borderRadius: 4
        }
      },
      dataLabels: {
        enabled: true,
        formatter: val => `₺${val.toLocaleString()}`
      },
      tooltip: {
        y: {
          formatter: val => `₺${val.toLocaleString()}`
        }
      }
    });

    topPropertiesChart.render();
  });
  window.addEventListener('filtersApplied', function (event) {
    const data = event.detail[0];

    const table = window.LaravelDataTables['property-table'];
    if (table) {
      // Stringify the filters object before storing
      window.filters = JSON.parse(JSON.stringify(data.filters));

      // Force a full reload
      table.ajax.reload();
    }
  });
  $('body').on('click', '.property_delete', function (e) {
    e.preventDefault();
    var property_id = $(this).data('id');
    var title = $(this).data('title') || 'Delete Property';
    var text = $(this).data('text') || "You won't be able to revert this!";
    var confirmButtonText = $(this).data('confirm-button-text') || 'Yes, delete it!';
    var cancelButtonText = $(this).data('cancel-button-text') || 'No, cancel!';

    Swal.fire({
      title: title,
      text: text,
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: confirmButtonText,
      customClass: {
        confirmButton: 'btn btn-primary me-3',
        cancelButton: 'btn btn-label-secondary'
      },
      buttonsStyling: false
    }).then(function (result) {
      if (result.value) {
        $.ajax({
          url: '/Property-list/' + property_id,
          type: 'DELETE',
          data: {
            _token: $('meta[name="csrf-token"]').attr('content'),
            property_id: property_id
          },
          success: function (response) {
            if (response.success == true) {
              Swal.fire({
                icon: 'success',
                text: response.msg,
                customClass: {
                  confirmButton: 'btn btn-success'
                }
              });
              dt_properties.DataTable().ajax.reload();
            }
            if (response.status == 'error') {
              Swal.fire({
                icon: 'error',
                text: response.message,
                customClass: {
                  confirmButton: 'btn btn-danger'
                }
              });
            }
          }
        });
      }
    });
  });
})();
