(function () {
  let borderColor, labelColor, headingColor, legendColor;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }

  let TransferLineChart;
  let TransferDonutChart;

  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: config.colors.info,
      series4: config.colors.danger
    }
  };

  // 👉 Listen for donut chart data
  window.addEventListener('initCategoryChart', function (event) {
    const { labels, series } = event.detail[0];
    initTransferDonutChart(labels, series);
  });

  // 👉 Listen for line/area chart data
  window.addEventListener('TransferChartDataUpdated', function (event) {
    const { categories, series } = event.detail[0];
    initTransferLineChart(series, categories);
  });

  function initTransferLineChart(series, categories) {
    const allValues = series.flatMap(s => s.data);
    const maxValue = Math.max(...allValues);
    const yAxisMax = Math.ceil(maxValue);

    const chartEl = document.querySelector('#TransferLineChart');
    const config = {
      series: series,
      chart: {
        height: 320,
        type: 'area',
        toolbar: { show: false },
        zoom: { enabled: false }
      },
      stroke: {
        curve: 'smooth',
        width: 3
      },
      markers: {
        size: 5,
        strokeColors: chartColors.line.series2
      },
      colors: [chartColors.line.series1, chartColors.line.series2, chartColors.line.series3, chartColors.line.series4],
      fill: {
        opacity: [0.3, 1]
      },
      grid: {
        borderColor,
        strokeDashArray: 8
      },
      legend: {
        position: 'bottom',
        fontSize: '13px',
        labels: { colors: headingColor }
      },
      xaxis: {
        categories: categories,
        labels: { style: { colors: labelColor } }
      },
      yaxis: {
        max: yAxisMax,
        labels: {
          formatter: val => val.toLocaleString()
        }
      }
    };

    if (!TransferLineChart) {
      TransferLineChart = new ApexCharts(chartEl, config);
      TransferLineChart.render();
    } else {
      TransferLineChart.updateOptions(config);
    }
  }

  function initTransferDonutChart(labels, series) {
    const chartEl = document.querySelector('#TransferDonutChart');
    const config = {
      chart: {
        type: 'donut',
        height: 400
      },
      labels: labels,
      series: series,
      colors: [
        chartColors.donut.series1,
        chartColors.donut.series2,
        chartColors.donut.series3,
        chartColors.donut.series4
      ],
      stroke: { width: 0 },
      legend: {
        position: 'bottom',
        fontSize: '13px',
        labels: { colors: headingColor }
      },
      plotOptions: {
        pie: {
          donut: {
            size: '75%',
            labels: {
              show: true,
              total: {
                show: true,
                label: 'Total',
                formatter: function (w) {
                  return w.globals.seriesTotals.reduce((a, b) => a + b, 0);
                }
              }
            }
          }
        }
      }
    };

    if (!TransferDonutChart) {
      TransferDonutChart = new ApexCharts(chartEl, config);
      TransferDonutChart.render();
    } else {
      TransferDonutChart.updateOptions(config);
    }
  }
})();
