'use strict';
(function () {
  const fullToolbar = [
    [{ font: [] }, { size: [] }],
    ['bold', 'italic', 'underline', 'strike'],
    [{ color: [] }, { background: [] }],
    [{ script: 'super' }, { script: 'sub' }],
    [{ header: '1' }, { header: '2' }, 'blockquote', 'code-block'],
    [{ list: 'ordered' }, { list: 'bullet' }, { indent: '-1' }, { indent: '+1' }],
    [{ direction: 'rtl' }],
    ['link', 'image', 'video', 'formula'],
    ['clean']
  ];

  const fullEditor = new Quill('#full-editor', {
    bounds: '#full-editor',
    placeholder: 'Type Something...',
    modules: {
      formula: true,
      toolbar: fullToolbar
    },
    theme: 'snow'
  });

  const fullEditor2 = new Quill('#full-editor2', {
    bounds: '#full-editor2',
    placeholder: 'Type Something...',
    modules: {
      formula: true,
      toolbar: fullToolbar
    },
    theme: 'snow'
  });

  // Save globally for use later
  window.fullEditor = fullEditor;
  window.fullEditor2 = fullEditor2;

  // Sync editor1 with hidden input
  fullEditor.root.innerHTML = document.getElementById('quill-content').value || '';
  fullEditor.on('text-change', function () {
    const html = fullEditor.root.innerHTML;
    document.getElementById('quill-content').value = html;
    document.getElementById('quill-content').dispatchEvent(new Event('input'));
  });

  // Optional: do the same for editor2 if needed
  fullEditor2.root.innerHTML = document.getElementById('quill-content2')?.value || '';
  fullEditor2.on('text-change', function () {
    const html = fullEditor2.root.innerHTML;
    if (document.getElementById('quill-content2')) {
      document.getElementById('quill-content2').value = html;
      document.getElementById('quill-content2').dispatchEvent(new Event('input'));
    }
  });

  // Updated insertVariable to accept an editor name or instance
  window.insertVariable = function (variableKey, editorName = 'fullEditor') {
    const editors = {
      fullEditor,
      fullEditor2
    };

    const editor = editors[editorName];
    if (!editor) return;

    const range = editor.getSelection();
    if (!range) return;

    const variableMap = {
      company_name: 'Company Name',
      date: 'Date',
      based_balance: 'Based Balance'
    };

    const label = variableMap[variableKey] || variableKey;
    const spanHtml = `<span class="badge bg-primary" contenteditable="false" data-variable="${variableKey}">%${variableKey}%</span>`;

    editor.clipboard.dangerouslyPasteHTML(range.index, spanHtml);
  };

  window.addEventListener('DOMContentLoaded', function () {
    fullEditor.root.innerHTML = document.getElementById('quill-content').value || '';
    if (document.getElementById('quill-content2')) {
      fullEditor2.root.innerHTML = document.getElementById('quill-content2').value || '';
    }
  });
})();
