import axios from 'axios';
window.axios = axios;
window.axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';

// CSRF Token (Laravel)
const token = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
if (token) {
  window.axios.defaults.headers.common['X-CSRF-TOKEN'] = token;
  console.log('CSRF token:', token);
} else {
  console.warn('CSRF token not found.');
}

// Laravel Echo + socket.io
import Echo from 'laravel-echo';
import io from 'socket.io-client';

// Optional: make sure old global io is removed (prevents v4 interference)
if (window.io) {
  console.warn('Removing existing global window.io');
  delete window.io;
}
const socketio = io;
// Don't overwrite window.io if not necessary
// window.io = socketio;

window.Echo = new Echo({
  broadcaster: 'socket.io',
  host: `${window.location.hostname}:8082`,
  client: io, // Force using 2.4.0
  transports: ['websocket', 'polling'],
  forceTLS: false,
  withCredentials: true
});
try {
  console.log('Echo initialized:', window.Echo);

  // Connection events
  window.Echo.connector.socket.on('connect', () => {
    console.log('Socket connected! ID:', window.Echo.socketId());

    // Only subscribe after connection
    window.Echo.channel('RefreshDataTable').listen('.RefreshDataTable', e => {
      console.log(e);
    });
  });

  window.Echo.connector.socket.on('disconnect', () => {
    console.warn('Socket disconnected');
  });

  // Error handling
  window.Echo.connector.socket.on('connect_error', error => {
    console.error('Connection error:', error);
  });
} catch (error) {
  console.error('Echo initialization failed:', error);
}
