@extends('layouts/AgentLayoutMaster')

@section('title', 'الصناديق')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/pickr/pickr-themes.scss'])@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/cleavejs/cleave.js', 'resources/assets/vendor/libs/cleavejs/cleave-phone.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/pickr/pickr.js'])


@endsection

@section('page-script')


    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    <script type="module">
        document.addEventListener('DOMContentLoaded', function() {
            const waitForTable = setInterval(function() {
                const table = window.LaravelDataTables?.["balance-table"];
                if (table) {
                    clearInterval(waitForTable); // توقف عند إيجاد الجدول

                    table.on('draw', function() {
                        table.rows().every(function() {
                            const data = this.data();
                            const $row = $(this.node());

                            if (data.account_name === 'مجموع الصناديق') {
                                $row.addClass('table-primary fw-bold');
                            }

                            if (data.account_name === 'مجموع الحوالات غير المستلمة') {
                                $row.addClass('table-warning fw-semibold');
                            }

                            if (data.account_name === 'مجموع العمولات') {
                                $row.addClass('table-success fw-semibold');
                            }
                        });
                    });
                }
            }, 100); // تحقق كل 100ms
        });
    </script>
    <script>
        window.addEventListener("CopyBalanceReconiliationEvent", function() {
            const hiddenDiv = document.getElementById("written_balance_reconciliation_content");

            // Create a temporary container with the same HTML
            const tempDiv = document.createElement("div");
            tempDiv.innerHTML = hiddenDiv.innerHTML;

            // Optional: apply styles from hiddenDiv (if needed)
            tempDiv.setAttribute("style", "position: absolute; left: -9999px;");
            document.body.appendChild(tempDiv);

            // Create a range and select the content
            const range = document.createRange();
            range.selectNodeContents(tempDiv);

            const selection = window.getSelection();
            selection.removeAllRanges();
            selection.addRange(range);

            // Execute copy command
            try {
                document.execCommand("copy");
                toastr['success']('HTML content copied', 'Success!', {
                    closeButton: true,
                    tapToDismiss: false,
                });
            } catch (err) {
                alert("Failed to copy.");
            }

            // Clean up
            document.body.removeChild(tempDiv);
            selection.removeAllRanges();
        })
    </script>
@endsection
@section('page-style')
    <style>
        tbody tr {
            font-family: 'Courier New', monospace;
        }

        .parent-row {
            font-weight: bold;
            background-color: #f8f9fa;
        }

        .child-row {
            background-color: #fff;
        }

        .text-end {
            text-align: right !important;
        }
    </style>
@endsection

@section('content')
    @livewire('accounts.statistics')

    <div class="card ">

        <div class="card-datatable table-responsive">


            {{ $dataTable->table(['style' => 'width:100%'], true) }}
        </div>
        <!-- Offcanvas to add new user -->

    </div>


@endsection
