@extends('layouts/AgentLayoutMaster')

@php
    $breadcrumbs = [
        ['link' => 'home', 'name' => 'Home'],
        ['link' => 'javascript:void(0)', 'name' => 'User'],
        ['name' => 'Profile'],
    ];
@endphp
@section('title', $title)

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/pickr/pickr-themes.scss'])@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/pickr/pickr.js'])


@endsection

@section('page-script')


    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}

@endsection
@section('page-style')
    <style>
        .page {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ticker-container {
            display: flex;
            align-items: center;
            direction: rtl;
            margin: 0;
            padding: 0;
            width: 100%;
            /* Make it full width */
            background: white;
            /* Match the ticker background */
            box-sizing: border-box;
            /* Prevent padding from breaking layout */
        }

        .tickernews {
            flex: 1;
            /* Take remaining space */
            background: white;
            color: black;
            overflow: hidden;
            white-space: nowrap;
            padding: 10px;
            display: flex;
            align-items: center;
            direction: rtl;
        }

        .news {
            display: inline-block;
            animation: scroll 15s linear infinite;
        }

        .news span {
            margin-right: 40px;
        }

        .tickernews:hover .news {
            animation-play-state: paused;
        }

        @keyframes scroll {
            from {
                transform: translateX(-100%);
            }

            to {
                transform: translateX(100%);
            }
        }
    </style>
@endsection

@section('content')

    <livewire:components.filter-component model="App\Models\LedgerExchange" :filters="$filters" table_id="exchange-table" />

    <div class="card">

        <div class="card-datatable table-responsive">
            {{ $dataTable->table(['style' => 'width:100%'], true) }}
        </div>
        <!-- Offcanvas to add new user -->

    </div>






@endsection
