@php
    $extra = $row['extra'] ?? null;
    if (is_string($extra)) {
        $extra = json_decode($extra, true);
    }
    $isChecked = !isset($extra['show']) || $extra['show'];
    $hasValidCode =
        isset($row['account_code']) && !empty($row['account_code']) && strpos($row['account_code'], 'xx') === false;
@endphp

@if ($hasValidCode)
    <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.copy') }}"
        x-on:click="$dispatch('CopyBalanceReconiliation', { code: '{{ $row['account_code'] }}' })">
        <i class="tf-icons ti ti-copy"></i>
    </button>
    <a class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.statements') }}" _blank
        href="/Statements?account_code={{ $row['account_code'] }}">
        <i class="tf-icons ti ti-report"></i>
    </a>
@endif
