@extends('layouts.layoutMaster')

@section('title', 'الصرف')


@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/pickr/pickr-themes.scss'])@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/pickr/pickr.js'])


@endsection

@section('page-script')



    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    <script>
        document.getElementById("copyBtn").addEventListener("click", function() {
            const hiddenDiv = document.getElementById("written_balance_reconciliation_content");

            // Create a temporary container with the same HTML
            const tempDiv = document.createElement("div");
            tempDiv.innerHTML = hiddenDiv.innerHTML;

            // Optional: apply styles from hiddenDiv (if needed)
            tempDiv.setAttribute("style", "position: absolute; left: -9999px;");
            document.body.appendChild(tempDiv);

            // Create a range and select the content
            const range = document.createRange();
            range.selectNodeContents(tempDiv);

            const selection = window.getSelection();
            selection.removeAllRanges();
            selection.addRange(range);

            // Execute copy command
            try {
                document.execCommand("copy");
                toastr['success']('HTML content copied', 'Success!', {
                    closeButton: true,
                    tapToDismiss: false,
                });
            } catch (err) {
                alert("Failed to copy.");
            }

            // Clean up
            document.body.removeChild(tempDiv);
            selection.removeAllRanges();
        });
    </script>

    <script>
        document.getElementById('screenshotBtn').addEventListener('click', async () => {
            const target = document.getElementById('mutabaka');

            html2canvas(target, {
                useCORS: true,
                scale: 2
            }).then(async canvas => {
                canvas.toBlob(async blob => {
                    try {
                        // Check if clipboard API is available
                        if (!navigator.clipboard || !navigator.clipboard.write) {
                            alert(
                                "❌ Clipboard API not supported in your browser. Try Chrome with HTTPS."
                            );
                            return;
                        }

                        // ClipboardItem fallback if needed
                        if (typeof ClipboardItem === "undefined") {
                            window.ClipboardItem = function(items) {
                                return {
                                    [Symbol.toStringTag]: "ClipboardItem",
                                    types: Object.keys(items),
                                    getType: (type) => Promise.resolve(items[type])
                                };
                            };
                        }

                        const item = new ClipboardItem({
                            'image/png': blob
                        });
                        await navigator.clipboard.write([item]);
                        alert('📸 تم نسخ صورة المطابقة بنجاح إلى الحافظة!');
                    } catch (err) {
                        alert(
                            '⚠️ فشل النسخ إلى الحافظة. تأكد من استخدام HTTPS أو استخدم متصفح يدعمه.'
                        );
                        console.error(err);
                    }
                });
            });
        });
    </script>
@endsection
@section('page-style')

@endsection

@section('content')
    @livewire('exchange.add')

    <div class="card">


        <div class="card-datatable table-responsive">
            {{ $dataTable->table(['class' => 'table table-hover', 'style' => 'width:100%'], true) }}
        </div>
        <!-- Offcanvas to add new user -->

    </div>
    @livewire('transfers.show-transfer-receipt')
    @livewire('logs.audit')

@endsection
