@extends('layouts.layoutMaster')

@section('title', 'كشف الحساب')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/pickr/pickr-themes.scss'])@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/cleavejs/cleave.js', 'resources/assets/vendor/libs/cleavejs/cleave-phone.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/pickr/pickr.js'])


@endsection

@section('page-script')


    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    <script>
        window.addEventListener('filtersApplied', function(event) {

            const data = event.detail[0];

            const table = window.LaravelDataTables['transaction-table'];
            if (table) {
                // Stringify the filters object before storing
                window.filters = JSON.parse(JSON.stringify(data.filters));

                // Force a full reload
                table.ajax.reload();
            }
        });
    </script>
@endsection
@section('page-style')


@endsection

@section('content')


    @livewire('exchange.balance-reconciliation', ['type' => 'account_statement', 'account_code' => $account_code])
    @livewire('statements.details')
    @livewire('transfer.transfer-info')
    <div class="card">

        <div class="card-datatable table-responsive">
            {{ $dataTable->table(['style' => 'width:100%'], true) }}
        </div>
        <!-- Offcanvas to add new user -->

    </div>
    @livewire('transfers.show-transfer-receipt')
    @livewire('transfers.cancel-transfer')
    @livewire('attachment.add')
    @livewire('logs.audit')
    @livewire('transfers.show-transfer-media')
@endsection
