@extends('layouts.layoutMaster')

@section('title', 'القوالب')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/pickr/pickr-themes.scss'])
    <link href="https://unpkg.com/grapesjs/dist/css/grapes.min.css" rel="stylesheet" />
@endsection


@section('vendor-script')
    @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/cleavejs/cleave.js', 'resources/assets/vendor/libs/cleavejs/cleave-phone.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/pickr/pickr.js'])
    @vite(['resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'])
    @vite(['resources/assets/vendor/libs/quill/katex.js', 'resources/assets/vendor/libs/quill/quill.js'])
    @vite(['resources/assets/vendor/libs/quill/typography.scss', 'resources/assets/vendor/libs/quill/katex.scss', 'resources/assets/vendor/libs/quill/editor.scss'])
@endsection

@section('page-script')
    <script src="https://unpkg.com/grapesjs"></script>
    @vite('resources/js/Transfer/Templates/index.js')
    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    <script>
        const editor = grapesjs.init({
            container: '#gjs',
            height: '90vh',
            width: 'auto',
            fromElement: false,
            storageManager: {
                autoload: false
            },
            blockManager: {
                appendTo: '#blocks',
                blocks: [{
                        id: 'text',
                        label: 'Text',
                        content: '<p>Insert text here</p>'
                    },
                    {
                        id: 'image',
                        label: 'Image',
                        content: '<img src="https://via.placeholder.com/150" />'
                    },
                    {
                        id: 'customer_name',
                        label: 'Customer Name',
                        content: '<span>Customer Name</span>'
                    },
                    {
                        id: 'items_table',
                        label: 'Items Table',
                        content: `<table border="1" width="100%">
                            <tr><th>Item</th><th>Qty</th><th>Price</th></tr>
                            <tr><td>Sample</td><td>1</td><td>0.00</td></tr>
                          </table>`
                    }
                ]
            },
            panelManager: {
                appendTo: '#panels'
            },
            layerManager: {
                appendTo: '#layers-container'
            },
            selectorManager: {
                appendTo: '#styles-container'
            },
            styleManager: {
                appendTo: '#styles-container'
            }
        });
    </script>
@endsection
@section('page-style')
@endsection

@section('content')
    <livewire:components.filter-component model="App\Models\LedgerTransfer" :filters="$filters" table_id="transfer-table" />
    @livewire('templates.add')

    <form method="POST" action="">
        @csrf
        <input type="text" name="name" placeholder="Template Name" required />
        <div style="display:flex; height:90vh;">
            <div id="blocks" style="width:200px; border-right:1px solid #ccc;"></div>
            <div id="gjs" style="flex:1;"></div>
            <div id="styles-container" style="width:200px; border-left:1px solid #ccc;"></div>
        </div>

        <button type="submit">Save Template</button>
    </form>

    <div class="card">

        <div class="card-datatable table-responsive">
            {{ $dataTable->table(['style' => 'width:100%'], true) }}
        </div>
        <!-- Offcanvas to add new user -->

    </div>
@endsection
