@extends('layouts.charity-module')

@section('title', 'Database Schema')

@section('content')
<div class="row">
    <div class="col-12">
        <h1>Charity Module Database Schema Design</h1>
        
        <div class="card">
            <div class="card-body">
                <h2>Overview</h2>
                <p>This section outlines the database schema design for the charity module, which integrates with the existing donation system and supports independent charity budgets, allocations, and disbursements.</p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Tables</h4>
            </div>
            <div class="card-body">
                <div class="accordion" id="accordionTables">
                    <!-- Charity Budgets -->
                    <div class="card">
                        <div class="card-header" id="headingOne">
                            <h5 class="mb-0">
                                <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    1. Charity Budgets
                                </button>
                            </h5>
                        </div>
                        <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionTables">
                            <div class="card-body bg-light-secondary p-1 rounded">
                                <pre><code>Schema::create('charity_budgets', function (Blueprint $table) {
    $table->id();
    $table->string('name');                   // E.g., "Ramadan 2025", "Student Scholarships 2025"
    $table->text('description')->nullable();
    $table->float('target_amount');           // Target budget amount
    $table->float('current_amount')->default(0); // Current allocated amount
    $table->float('disbursed_amount')->default(0); // Amount already disbursed
    $table->integer('currency')->default(1);
    $table->date('start_date');
    $table->date('end_date')->nullable();     // Optional end date for budget
    $table->boolean('is_active')->default(true);
    $table->foreignId('wallet_id')->nullable()->constrained('wallets')->onDelete('set null'); // Associated wallet if using Bavix
    $table->foreignId('category_id')->nullable()->constrained('expense_categories')->onDelete('set null');
    $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
    $table->timestamps();
});</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Budget Allocations -->
                    <div class="card">
                        <div class="card-header" id="headingTwo">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    2. Budget Allocations
                                </button>
                            </h5>
                        </div>
                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionTables">
                            <div class="card-body bg-light-secondary p-1 rounded">
                                <pre><code>Schema::create('budget_allocations', function (Blueprint $table) {
    $table->id();
    $table->foreignId('charity_budget_id')->constrained('charity_budgets')->onDelete('cascade');
    $table->float('amount');
    $table->integer('currency')->default(1);
    $table->date('allocation_date');
    $table->enum('source_type', ['donation', 'foundation_fund', 'transfer']);
    $table->unsignedBigInteger('source_id')->nullable(); // ID of the source (donation_id, account_id, etc.)
    $table->text('notes')->nullable();
    $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
    $table->integer('transaction_id')->nullable(); // For wallet transactions
    $table->timestamps();
});</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Charity Disbursements -->
                    <div class="card">
                        <div class="card-header" id="headingThree">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    3. Charity Disbursements
                                </button>
                            </h5>
                        </div>
                        <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionTables">
                            <div class="card-body bg-light-secondary p-1 rounded">
                                <pre><code>Schema::create('charity_disbursements', function (Blueprint $table) {
    $table->id();
    $table->foreignId('charity_budget_id')->constrained('charity_budgets')->onDelete('cascade');
    $table->float('amount');
    $table->integer('currency')->default(1);
    $table->date('disbursement_date');
    $table->string('recipient_name');
    $table->string('recipient_contact')->nullable();
    $table->text('purpose');
    $table->text('notes')->nullable();
    $table->enum('status', ['pending', 'approved', 'disbursed', 'cancelled'])->default('pending');
    $table->foreignId('category_id')->nullable()->constrained('expense_categories')->onDelete('set null');
    $table->foreignId('subcategory_id')->nullable()->constrained('expense_subcategories')->onDelete('set null');
    $table->foreignId('payment_method_id')->nullable()->constrained('paymentmethods')->onDelete('set null');
    $table->foreignId('requested_by')->constrained('users')->onDelete('cascade');
    $table->foreignId('approved_by')->nullable()->constrained('users')->onDelete('set null');
    $table->timestamp('approved_at')->nullable();
    $table->integer('transaction_id')->nullable(); // For wallet transactions
    $table->timestamps();
});</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Charity Beneficiaries -->
                    <div class="card">
                        <div class="card-header" id="headingFour">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                    4. Charity Beneficiaries (Optional)
                                </button>
                            </h5>
                        </div>
                        <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionTables">
                            <div class="card-body bg-light-secondary p-1 rounded">
                                <pre><code>Schema::create('charity_beneficiaries', function (Blueprint $table) {
    $table->id();
    $table->string('name');
    $table->string('contact_info')->nullable();
    $table->text('address')->nullable();
    $table->string('identification_number')->nullable();
    $table->text('notes')->nullable();
    $table->boolean('is_active')->default(true);
    $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
    $table->timestamps();
});</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Additional tables -->
                    <div class="card">
                        <div class="card-header" id="headingFive">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                    5. Additional Tables
                                </button>
                            </h5>
                        </div>
                        <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionTables">
                            <div class="card-body">
                                <p>The schema includes several additional tables to support the charity module functionality:</p>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">Beneficiary Disbursements - For tracking which beneficiaries received what</li>
                                    <li class="list-group-item">Donation Budget Allocations - For tracking conditional donations</li>
                                    <li class="list-group-item">Budget Transfers - For transferring funds between budgets</li>
                                    <li class="list-group-item">Charity Documents - For storing receipts, approvals, etc.</li>
                                </ul>
                                <p class="mt-2">See the full schema documentation for details on these tables.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Entity Relationship Diagram</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <div class="alert alert-info">
                            <div class="alert-body">
                                <p>The ERD shows the relationships between all tables in the charity module and their connections to existing tables.</p>
                            </div>
                        </div>
                        
                        <div class="bg-light-secondary p-2 rounded">
                            <pre>
+----------------+       +-------------------+       +---------------------+
| donations      |------>| donation_budget   |<------| charity_budgets     |
+----------------+       | allocations       |       +---------------------+
                         +-------------------+       | id                  |
                                 ^                   | name                |
                                 |                   | description         |
                                 |                   | target_amount       |
+----------------+               |                   | current_amount      |
| accounts       |---------------+                   | disbursed_amount    |
+----------------+                                   | currency            |
                                                     | start_date          |
                                                     | end_date            |
+----------------+       +-------------------+       | is_active           |
| wallets        |<------| budget_allocations|<------| wallet_id           |
+----------------+       +-------------------+       | category_id         |
                                 |                   | created_by          |
                                 |                   +---------------------+
                                 v                           |
                         +-------------------+               |
                         | budget_transfers  |---------------+
                         +-------------------+               |
                                                             |
+----------------+       +-------------------+               |
| expense        |<------| charity           |<--------------+
| categories     |       | disbursements     |
+----------------+       +-------------------+</pre>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Integration with Bavix Wallet</h4>
            </div>
            <div class="card-body">
                <p>The charity module integrates with the Bavix Wallet package through:</p>
                <div class="row">
                    <div class="col-md-6">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">Budget Wallets</h5>
                                <p>Each charity budget can have its own wallet (wallet_id in charity_budgets table)</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">Transaction Tracking</h5>
                                <p>Budget allocations, disbursements, and transfers all track transaction_id for wallet operations</p>
                            </div>
                        </div>
                    </div>
                </div>
                <p class="mt-2">This allows for proper accounting and tracking of all financial movements within the charity module.</p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Performance Considerations</h4>
            </div>
            <div class="card-body">
                <p>For optimal performance, the following indexes should be added:</p>
                <div class="bg-light-secondary p-1 rounded">
                    <pre><code>// Add indexes for frequently queried columns
Schema::table('charity_budgets', function (Blueprint $table) {
    $table->index('is_active');
    $table->index('start_date');
    $table->index('end_date');
});

Schema::table('charity_disbursements', function (Blueprint $table) {
    $table->index('status');
    $table->index('disbursement_date');
});

Schema::table('budget_allocations', function (Blueprint $table) {
    $table->index(['source_type', 'source_id']);
    $table->index('allocation_date');
});</code></pre>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Migration Strategy</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <ul class="timeline">
                            <li class="timeline-item">
                                <span class="timeline-point timeline-point-indicator"></span>
                                <div class="timeline-event">
                                    <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                        <h6>Create all new tables</h6>
                                        <span class="timeline-event-time">Step 1</span>
                                    </div>
                                </div>
                            </li>
                            <li class="timeline-item">
                                <span class="timeline-point timeline-point-indicator"></span>
                                <div class="timeline-event">
                                    <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                        <h6>Add new columns to existing tables</h6>
                                        <span class="timeline-event-time">Step 2</span>
                                    </div>
                                </div>
                            </li>
                            <li class="timeline-item">
                                <span class="timeline-point timeline-point-indicator"></span>
                                <div class="timeline-event">
                                    <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                        <h6>Create indexes</h6>
                                        <span class="timeline-event-time">Step 3</span>
                                    </div>
                                </div>
                            </li>
                            <li class="timeline-item">
                                <span class="timeline-point timeline-point-indicator"></span>
                                <div class="timeline-event">
                                    <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                        <h6>Implement foreign key constraints</h6>
                                        <span class="timeline-event-time">Step 4</span>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
