@extends('layouts.charity-module')

@section('title', 'User Flows & Wireframes')

@section('content')
<div class="row">
    <div class="col-12">
        <h1>Charity Module User Flows and Wireframes</h1>
        
        <div class="card">
            <div class="card-body">
                <h2>Overview</h2>
                <p>This section outlines the key user flows and wireframes for the charity module, demonstrating how users will navigate through different processes and interact with the system.</p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">User Roles</h4>
            </div>
            <div class="card-body">
                <p>The charity module supports several user roles with different permissions:</p>
                <div class="row">
                    <div class="col-md-4">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Budget Manager</h5>
                                    </div>
                                    <div class="avatar bg-primary p-50">
                                        <div class="avatar-content">
                                            <i data-feather="dollar-sign" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Creates and manages charity budgets</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Allocation Manager</h5>
                                    </div>
                                    <div class="avatar bg-info p-50">
                                        <div class="avatar-content">
                                            <i data-feather="trending-up" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Allocates funds to budgets</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Disbursement Requester</h5>
                                    </div>
                                    <div class="avatar bg-success p-50">
                                        <div class="avatar-content">
                                            <i data-feather="file-text" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Requests disbursements from budgets</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-warning">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Disbursement Approver</h5>
                                    </div>
                                    <div class="avatar bg-warning p-50">
                                        <div class="avatar-content">
                                            <i data-feather="check-square" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Reviews and approves disbursement requests</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-danger">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Reporter</h5>
                                    </div>
                                    <div class="avatar bg-danger p-50">
                                        <div class="avatar-content">
                                            <i data-feather="bar-chart-2" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Generates and views reports</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-secondary">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Administrator</h5>
                                    </div>
                                    <div class="avatar bg-secondary p-50">
                                        <div class="avatar-content">
                                            <i data-feather="settings" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Has full access to all functions</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Core User Flows</h4>
            </div>
            <div class="card-body">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="budget-tab" data-toggle="tab" href="#budget-flow" aria-controls="budget-flow" role="tab" aria-selected="true">Budget Creation</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="donation-tab" data-toggle="tab" href="#donation-flow" aria-controls="donation-flow" role="tab" aria-selected="false">Donation Allocation</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="disbursement-tab" data-toggle="tab" href="#disbursement-flow" aria-controls="disbursement-flow" role="tab" aria-selected="false">Disbursement</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="transfer-tab" data-toggle="tab" href="#transfer-flow" aria-controls="transfer-flow" role="tab" aria-selected="false">Budget Transfer</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="reporting-tab" data-toggle="tab" href="#reporting-flow" aria-controls="reporting-flow" role="tab" aria-selected="false">Reporting</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="budget-flow" aria-labelledby="budget-tab" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">1. Budget Creation and Management Flow</h5>
                                <div class="bg-light-secondary p-2 rounded mb-2">
                                    <pre>
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Charity        │────▶│  Budgets List   │────▶│  Create New     │
│  Dashboard      │     │  Page           │     │  Budget Form    │
│                 │     │                 │     │                 │
└─────────────────┘     └─────────────────┘     └────────┬────────┘
                                                         │
                                                         ▼
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Budget         │◀────│  Budget         │◀────│  Form           │
│  Details View   │     │  Created        │     │  Validation     │
│                 │     │                 │     │                 │
└─────────────────┘     └─────────────────┘     └─────────────────┘</pre>
                                </div>
                                
                                <h6 class="mt-3">Wireframe: Budget Creation Form</h6>
                                <div class="card">
                                    <div class="card-body">
                                        <div class="border p-2 rounded">
                                            <div class="d-flex justify-content-between mb-1">
                                                <h6>Create New Budget</h6>
                                                <i data-feather="x" class="font-medium-3"></i>
                                            </div>
                                            <hr>
                                            <div class="form-group">
                                                <label for="budget-name">Budget Name*:</label>
                                                <input type="text" class="form-control" id="budget-name">
                                            </div>
                                            <div class="form-group">
                                                <label for="description">Description:</label>
                                                <textarea class="form-control" id="description" rows="2"></textarea>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <div class="form-group">
                                                        <label for="target-amount">Target Amount*:</label>
                                                        <input type="text" class="form-control" id="target-amount">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label for="currency">Currency:</label>
                                                        <select class="form-control" id="currency">
                                                            <option>TRY</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="start-date">Start Date*:</label>
                                                        <input type="text" class="form-control" id="start-date" placeholder="MM/DD/YYYY">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="end-date">End Date:</label>
                                                        <input type="text" class="form-control" id="end-date" placeholder="MM/DD/YYYY">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="category">Category:</label>
                                                <select class="form-control" id="category">
                                                    <option>Select Category</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label>Wallet:</label>
                                                <div class="custom-control custom-radio mb-1">
                                                    <input type="radio" id="create-wallet" name="wallet-option" class="custom-control-input" checked>
                                                    <label class="custom-control-label" for="create-wallet">Create New Wallet</label>
                                                </div>
                                                <div class="custom-control custom-radio">
                                                    <input type="radio" id="existing-wallet" name="wallet-option" class="custom-control-input">
                                                    <label class="custom-control-label" for="existing-wallet">Use Existing Wallet</label>
                                                </div>
                                                <select class="form-control mt-1" id="wallet-select" disabled>
                                                    <option>Select Wallet</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label>Status:</label>
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input" id="status-switch" checked>
                                                    <label class="custom-control-label" for="status-switch">Active</label>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-end mt-2">
                                                <button type="button" class="btn btn-outline-secondary mr-1">Cancel</button>
                                                <button type="button" class="btn btn-primary">Save Budget</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="donation-flow" aria-labelledby="donation-tab" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">2. Donation Allocation Flow</h5>
                                <div class="bg-light-secondary p-2 rounded mb-2">
                                    <pre>
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Donations      │────▶│  Donation       │────▶│  Select         │
│  List Page      │     │  Details        │     │  Allocation     │
│                 │     │                 │     │                 │
└─────────────────┘     └─────────────────┘     └────────┬────────┘
                                                         │
                                                         ▼
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Allocation     │◀────│  Confirm        │◀────│  Allocation     │
│  Complete       │     │  Allocation     │     │  Form           │
│                 │     │                 │     │                 │
└─────────────────┘     └─────────────────┘     └─────────────────┘</pre>
                                </div>
                                
                                <h6 class="mt-3">Wireframe: Donation Allocation Form</h6>
                                <div class="card">
                                    <div class="card-body">
                                        <div class="border p-2 rounded">
                                            <div class="d-flex justify-content-between mb-1">
                                                <h6>Allocate Donation</h6>
                                                <i data-feather="x" class="font-medium-3"></i>
                                            </div>
                                            <hr>
                                            <div class="alert alert-info">
                                                <div class="alert-body">
                                                    <strong>Donation:</strong> #1234 - Ali Yilmaz - 5,000 TRY - 05/20/2025
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label>Donation Type:</label>
                                                <p><span class="badge badge-light-primary">Conditional (Ramadan Food)</span></p>
                                            </div>
                                            <div class="form-group">
                                                <label>Available Amount:</label>
                                                <p class="font-weight-bold">5,000 TRY</p>
                                            </div>
                                            <div class="form-group">
                                                <label>Allocate To:</label>
                                                <div class="border p-1 rounded">
                                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                                        <div class="custom-control custom-checkbox">
                                                            <input type="checkbox" class="custom-control-input" id="budget1" checked>
                                                            <label class="custom-control-label" for="budget1">Ramadan Food 2025</label>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            <input type="text" class="form-control form-control-sm mr-1" value="5,000">
                                                            <span>TRY</span>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                                        <div class="custom-control custom-checkbox">
                                                            <input type="checkbox" class="custom-control-input" id="budget2">
                                                            <label class="custom-control-label" for="budget2">Student Scholarships</label>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            <input type="text" class="form-control form-control-sm mr-1" disabled>
                                                            <span>TRY</span>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                                        <div class="custom-control custom-checkbox">
                                                            <input type="checkbox" class="custom-control-input" id="budget3">
                                                            <label class="custom-control-label" for="budget3">Orphan Support</label>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            <input type="text" class="form-control form-control-sm mr-1" disabled>
                                                            <span>TRY</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label>Remaining to Allocate:</label>
                                                <p class="font-weight-bold">0 TRY</p>
                                            </div>
                                            <div class="form-group">
                                                <label for="allocation-notes">Notes:</label>
                                                <textarea class="form-control" id="allocation-notes" rows="2"></textarea>
                                            </div>
                                            <div class="d-flex justify-content-end mt-2">
                                                <button type="button" class="btn btn-outline-secondary mr-1">Cancel</button>
                                                <button type="button" class="btn btn-primary">Confirm Allocation</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="disbursement-flow" aria-labelledby="disbursement-tab" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">3. Disbursement Request and Approval Flow</h5>
                                <div class="bg-light-secondary p-2 rounded mb-2">
                                    <pre>
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Charity        │────▶│  Disbursements  │────▶│  New            │
│  Dashboard      │     │  List Page      │     │  Disbursement   │
│                 │     │                 │     │  Form           │
└─────────────────┘     └─────────────────┘     └────────┬────────┘
                                                         │
                                                         ▼
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Disbursement   │◀────│  Request        │◀────│  Form           │
│  Details        │     │  Submitted      │     │  Validation     │
│                 │     │                 │     │                 │
└────────┬────────┘     └─────────────────┘     └─────────────────┘
         │
         ▼
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Approver       │────▶│  Approval       │────▶│  Disbursement   │
│  Review         │     │  Decision       │     │  Status Updated │
│                 │     │                 │     │                 │
└─────────────────┘     └─────────────────┘     └─────────────────┘</pre>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="mt-3">Wireframe: Disbursement Request Form</h6>
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="border p-2 rounded">
                                                    <div class="d-flex justify-content-between mb-1">
                                                        <h6>New Disbursement Request</h6>
                                                        <i data-feather="x" class="font-medium-3"></i>
                                                    </div>
                                                    <hr>
                                                    <div class="form-group">
                                                        <label for="budget-select">Budget*:</label>
                                                        <select class="form-control" id="budget-select">
                                                            <option>Ramadan Food 2025</option>
                                                        </select>
                                                        <small class="text-muted">Available: 85,000 TRY</small>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-8">
                                                            <div class="form-group">
                                                                <label for="disbursement-amount">Amount*:</label>
                                                                <input type="text" class="form-control" id="disbursement-amount" value="25,000">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="disbursement-currency">Currency:</label>
                                                                <select class="form-control" id="disbursement-currency">
                                                                    <option>TRY</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="disbursement-date">Disbursement Date*:</label>
                                                        <input type="text" class="form-control" id="disbursement-date" placeholder="MM/DD/YYYY" value="05/26/2025">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="recipient-name">Recipient Name*:</label>
                                                        <input type="text" class="form-control" id="recipient-name">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="recipient-contact">Recipient Contact:</label>
                                                        <input type="text" class="form-control" id="recipient-contact">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="purpose">Purpose*:</label>
                                                        <textarea class="form-control" id="purpose" rows="2"></textarea>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="category-select">Category*:</label>
                                                                <select class="form-control" id="category-select">
                                                                    <option>Food Distribution</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="subcategory-select">Subcategory:</label>
                                                                <select class="form-control" id="subcategory-select">
                                                                    <option>Ramadan Food Packages</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="payment-method">Payment Method*:</label>
                                                        <select class="form-control" id="payment-method">
                                                            <option>Bank Transfer</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="disbursement-notes">Notes:</label>
                                                        <textarea class="form-control" id="disbursement-notes" rows="2"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Multiple Beneficiaries (Optional):</label>
                                                        <div class="d-flex justify-content-end mb-1">
                                                            <button type="button" class="btn btn-sm btn-outline-primary">+ Add</button>
                                                        </div>
                                                        <div class="table-responsive">
                                                            <table class="table table-sm table-bordered">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Name</th>
                                                                        <th>Identification</th>
                                                                        <th>Amount</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>
                                                                        <td colspan="3" class="text-center">No beneficiaries added</td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Supporting Documents:</label>
                                                        <div class="border p-2 rounded text-center">
                                                            <p>Drag and drop files here or click to upload</p>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex justify-content-end mt-2">
                                                        <button type="button" class="btn btn-outline-secondary mr-1">Cancel</button>
                                                        <button type="button" class="btn btn-outline-primary mr-1">Save Draft</button>
                                                        <button type="button" class="btn btn-primary">Submit Request</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 class="mt-3">Wireframe: Disbursement Approval Screen</h6>
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="border p-2 rounded">
                                                    <div class="d-flex justify-content-between mb-1">
                                                        <h6>Disbursement Approval - Request #1234</h6>
                                                        <i data-feather="x" class="font-medium-3"></i>
                                                    </div>
                                                    <hr>
                                                    <div class="card mb-1">
                                                        <div class="card-header">
                                                            <h6 class="mb-0">Request Details</h6>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <p><strong>Budget:</strong> Ramadan Food 2025</p>
                                                                    <p><strong>Amount:</strong> 25,000 TRY</p>
                                                                    <p><strong>Disbursement Date:</strong> 05/26/2025</p>
                                                                    <p><strong>Recipient:</strong> Ankara Food Bank</p>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <p><strong>Purpose:</strong> Distribution of food packages to 100 families during Ramadan</p>
                                                                    <p><strong>Category:</strong> Food Distribution > Ramadan Food Packages</p>
                                                                    <p><strong>Payment Method:</strong> Bank Transfer</p>
                                                                    <p><strong>Requested By:</strong> Mehmet Yilmaz on 05/24/2025</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="card mb-1">
                                                        <div class="card-header">
                                                            <h6 class="mb-0">Supporting Documents</h6>
                                                        </div>
                                                        <div class="card-body">
                                                            <ul class="list-group list-group-flush">
                                                                <li class="list-group-item d-flex align-items-center">
                                                                    <i data-feather="file-text" class="mr-1"></i>
                                                                    <span>Quote_FoodBank.pdf</span>
                                                                </li>
                                                                <li class="list-group-item d-flex align-items-center">
                                                                    <i data-feather="file-text" class="mr-1"></i>
                                                                    <span>Beneficiary_List.xlsx</span>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                    <div class="card mb-1">
                                                        <div class="card-header">
                                                            <h6 class="mb-0">Approval Decision</h6>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="form-group">
                                                                <div class="custom-control custom-radio mb-1">
                                                                    <input type="radio" id="approve" name="decision" class="custom-control-input">
                                                                    <label class="custom-control-label" for="approve">Approve</label>
                                                                </div>
                                                                <div class="custom-control custom-radio mb-1">
                                                                    <input type="radio" id="reject" name="decision" class="custom-control-input">
                                                                    <label class="custom-control-label" for="reject">Reject</label>
                                                                </div>
                                                                <div class="custom-control custom-radio mb-1">
                                                                    <input type="radio" id="request-changes" name="decision" class="custom-control-input">
                                                                    <label class="custom-control-label" for="request-changes">Request Changes</label>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="approval-comments">Comments*:</label>
                                                                <textarea class="form-control" id="approval-comments" rows="2"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex justify-content-end mt-2">
                                                        <button type="button" class="btn btn-outline-secondary mr-1">Cancel</button>
                                                        <button type="button" class="btn btn-primary">Submit Decision</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="transfer-flow" aria-labelledby="transfer-tab" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">4. Budget Transfer Flow</h5>
                                <div class="bg-light-secondary p-2 rounded mb-2">
                                    <pre>
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Budgets        │────▶│  Budget         │────▶│  Transfer       │
│  List Page      │     │  Details        │     │  Funds Option   │
│                 │     │                 │     │                 │
└─────────────────┘     └─────────────────┘     └────────┬────────┘
                                                         │
                                                         ▼
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Transfer       │◀────│  Confirm        │◀────│  Transfer       │
│  Complete       │     │  Transfer       │     │  Form           │
│                 │     │                 │     │                 │
└─────────────────┘     └─────────────────┘     └─────────────────┘</pre>
                                </div>
                                
                                <h6 class="mt-3">Wireframe: Budget Transfer Form</h6>
                                <div class="card">
                                    <div class="card-body">
                                        <div class="border p-2 rounded">
                                            <div class="d-flex justify-content-between mb-1">
                                                <h6>Transfer Funds Between Budgets</h6>
                                                <i data-feather="x" class="font-medium-3"></i>
                                            </div>
                                            <hr>
                                            <div class="form-group">
                                                <label for="source-budget">Source Budget*:</label>
                                                <select class="form-control" id="source-budget">
                                                    <option>Ramadan Food 2025</option>
                                                </select>
                                                <small class="text-muted">Available: 85,000 TRY</small>
                                            </div>
                                            <div class="form-group">
                                                <label for="destination-budget">Destination Budget*:</label>
                                                <select class="form-control" id="destination-budget">
                                                    <option>Student Scholarships</option>
                                                </select>
                                                <small class="text-muted">Current Amount: 120,000 TRY</small>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <div class="form-group">
                                                        <label for="transfer-amount">Transfer Amount*:</label>
                                                        <input type="text" class="form-control" id="transfer-amount" value="15,000">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label for="transfer-currency">Currency:</label>
                                                        <select class="form-control" id="transfer-currency">
                                                            <option>TRY</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="transfer-date">Transfer Date*:</label>
                                                <input type="text" class="form-control" id="transfer-date" placeholder="MM/DD/YYYY" value="05/26/2025">
                                            </div>
                                            <div class="form-group">
                                                <label for="transfer-reason">Reason for Transfer*:</label>
                                                <textarea class="form-control" id="transfer-reason" rows="2"></textarea>
                                            </div>
                                            <div class="d-flex justify-content-end mt-2">
                                                <button type="button" class="btn btn-outline-secondary mr-1">Cancel</button>
                                                <button type="button" class="btn btn-primary">Confirm Transfer</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="reporting-flow" aria-labelledby="reporting-tab" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">5. Reporting Flow</h5>
                                <div class="bg-light-secondary p-2 rounded mb-2">
                                    <pre>
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Charity        │────▶│  Reports        │────▶│  Select Report  │
│  Dashboard      │     │  Dashboard      │     │  Type           │
│                 │     │                 │     │                 │
└─────────────────┘     └─────────────────┘     └────────┬────────┘
                                                         │
                                                         ▼
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│                 │     │                 │     │                 │
│  Export         │◀────│  View Report    │◀────│  Apply Filters  │
│  Report         │     │  Results        │     │  & Parameters   │
│                 │     │                 │     │                 │
└─────────────────┘     └─────────────────┘     └─────────────────┘</pre>
                                </div>
                                
                                <h6 class="mt-3">Wireframe: Report Generation Screen</h6>
                                <div class="card">
                                    <div class="card-body">
                                        <div class="border p-2 rounded">
                                            <h6>Charity Reports</h6>
                                            <ul class="nav nav-pills mb-2">
                                                <li class="nav-item">
                                                    <a class="nav-link active" href="#">Budget Utilization</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link" href="#">Donation Allocation</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link" href="#">Disbursement</a>
                                                </li>
                                            </ul>
                                            <div class="card mb-2">
                                                <div class="card-body">
                                                    <h6>Report Parameters</h6>
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="date-range">Date Range:</label>
                                                                <input type="text" class="form-control" id="date-range" value="01/01/2025 - 05/26/2025">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="budget-filter">Budget:</label>
                                                                <select class="form-control" id="budget-filter">
                                                                    <option>All Budgets</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="category-filter">Category:</label>
                                                                <select class="form-control" id="category-filter">
                                                                    <option>All Categories</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex justify-content-end">
                                                        <button type="button" class="btn btn-primary">Generate Report</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card mb-2">
                                                <div class="card-body">
                                                    <h6>Budget Utilization Report</h6>
                                                    <div class="border p-2 rounded mb-2 text-center">
                                                        <p>[Chart: Horizontal bars showing target vs current vs disbursed amounts for each budget]</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card">
                                                <div class="card-body">
                                                    <h6>Budget Details</h6>
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>Budget Name</th>
                                                                    <th>Target</th>
                                                                    <th>Current</th>
                                                                    <th>Disbursed</th>
                                                                    <th>%</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <td>Ramadan</td>
                                                                    <td>100,000</td>
                                                                    <td>85,000</td>
                                                                    <td>15,000</td>
                                                                    <td>15%</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Student</td>
                                                                    <td>200,000</td>
                                                                    <td>120,000</td>
                                                                    <td>80,000</td>
                                                                    <td>40%</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Orphan</td>
                                                                    <td>150,000</td>
                                                                    <td>150,000</td>
                                                                    <td>75,000</td>
                                                                    <td>50%</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="d-flex justify-content-end mt-2">
                                                        <button type="button" class="btn btn-outline-primary mr-1">Export PDF</button>
                                                        <button type="button" class="btn btn-outline-primary">Export Excel</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Role-Based Navigation Flows</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Budget Manager Navigation</h5>
                            </div>
                            <div class="card-body">
                                <div class="bg-light-secondary p-2 rounded">
                                    <pre>
Dashboard
  │
  ├─▶ Budgets List
  │     │
  │     ├─▶ Create New Budget
  │     │
  │     ├─▶ Edit Budget
  │     │
  │     ├─▶ Budget Details
  │     │     │
  │     │     ├─▶ View Allocations
  │     │     │
  │     │     └─▶ View Disbursements
  │     │
  │     └─▶ Transfer Funds
  │
  └─▶ Reports
        │
        └─▶ Budget Utilization Report</pre>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Allocation Manager Navigation</h5>
                            </div>
                            <div class="card-body">
                                <div class="bg-light-secondary p-2 rounded">
                                    <pre>
Dashboard
  │
  ├─▶ Donations List
  │     │
  │     ├─▶ Donation Details
  │     │     │
  │     │     └─▶ Allocate Donation
  │     │
  │     └─▶ New Donation
  │
  ├─▶ Allocations List
  │     │
  │     ├─▶ New Allocation
  │     │
  │     └─▶ Allocation Details
  │
  └─▶ Reports
        │
        └─▶ Donation Allocation Report</pre>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Disbursement Requester Navigation</h5>
                            </div>
                            <div class="card-body">
                                <div class="bg-light-secondary p-2 rounded">
                                    <pre>
Dashboard
  │
  ├─▶ Disbursements List
  │     │
  │     ├─▶ New Disbursement Request
  │     │
  │     └─▶ Disbursement Details
  │           │
  │           └─▶ Upload Documents
  │
  └─▶ Beneficiaries List
        │
        ├─▶ New Beneficiary
        │
        └─▶ Beneficiary Details</pre>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Disbursement Approver Navigation</h5>
                            </div>
                            <div class="card-body">
                                <div class="bg-light-secondary p-2 rounded">
                                    <pre>
Dashboard
  │
  ├─▶ Pending Approvals
  │     │
  │     └─▶ Review Disbursement
  │           │
  │           ├─▶ Approve
  │           │
  │           ├─▶ Reject
  │           │
  │           └─▶ Request Changes
  │
  └─▶ Disbursements List
        │
        └─▶ Disbursement Details
              │
              └─▶ Mark as Disbursed</pre>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Mobile Responsiveness</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h5>Mobile Dashboard</h5>
                        <div class="border p-2 rounded">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <h6>Charity Dashboard</h6>
                                <i data-feather="menu" class="font-medium-3"></i>
                            </div>
                            <div class="card mb-1">
                                <div class="card-body d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="mb-0">Active Budgets</p>
                                        <h4 class="mb-0">5</h4>
                                    </div>
                                    <i data-feather="chevron-right"></i>
                                </div>
                            </div>
                            <div class="card mb-1">
                                <div class="card-body d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="mb-0">Allocated (May)</p>
                                        <h4 class="mb-0">125,000 TRY</h4>
                                    </div>
                                    <i data-feather="chevron-right"></i>
                                </div>
                            </div>
                            <div class="card mb-1">
                                <div class="card-body d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="mb-0">Disbursed (May)</p>
                                        <h4 class="mb-0">75,000 TRY</h4>
                                    </div>
                                    <i data-feather="chevron-right"></i>
                                </div>
                            </div>
                            <div class="card mb-1">
                                <div class="card-body d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="mb-0">Pending Requests</p>
                                        <h4 class="mb-0">3</h4>
                                    </div>
                                    <i data-feather="chevron-right"></i>
                                </div>
                            </div>
                            <h6 class="mt-2">Budget Utilization</h6>
                            <div class="card mb-1">
                                <div class="card-body text-center">
                                    <p>[Chart]</p>
                                </div>
                            </div>
                            <h6 class="mt-2">Recent Activity</h6>
                            <div class="card mb-1">
                                <div class="card-body">
                                    <ul class="timeline">
                                        <li class="timeline-item">
                                            <span class="timeline-point timeline-point-indicator"></span>
                                            <div class="timeline-event">
                                                <p class="mb-0">05/26 - Disbursement approved</p>
                                            </div>
                                        </li>
                                        <li class="timeline-item">
                                            <span class="timeline-point timeline-point-indicator"></span>
                                            <div class="timeline-event">
                                                <p class="mb-0">05/25 - Allocation completed</p>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center mt-2">
                                <button type="button" class="btn btn-primary rounded-circle">
                                    <i data-feather="plus" class="font-medium-3"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <h5>Mobile Navigation Menu</h5>
                        <div class="border p-2 rounded">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <h6>☰ Menu</h6>
                                <i data-feather="x" class="font-medium-3"></i>
                            </div>
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar bg-light-primary p-50 mr-1">
                                            <div class="avatar-content">
                                                <i data-feather="user" class="font-medium-4"></i>
                                            </div>
                                        </div>
                                        <div>
                                            <h6 class="mb-0">Ahmed Yilmaz</h6>
                                            <small>Budget Manager</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item d-flex align-items-center">
                                    <i data-feather="home" class="mr-1"></i>
                                    <span>Dashboard</span>
                                </li>
                                <li class="list-group-item d-flex align-items-center">
                                    <i data-feather="dollar-sign" class="mr-1"></i>
                                    <span>Budgets</span>
                                </li>
                                <li class="list-group-item d-flex align-items-center">
                                    <i data-feather="trending-up" class="mr-1"></i>
                                    <span>Allocations</span>
                                </li>
                                <li class="list-group-item d-flex align-items-center">
                                    <i data-feather="credit-card" class="mr-1"></i>
                                    <span>Disbursements</span>
                                </li>
                                <li class="list-group-item d-flex align-items-center">
                                    <i data-feather="users" class="mr-1"></i>
                                    <span>Beneficiaries</span>
                                </li>
                                <li class="list-group-item d-flex align-items-center">
                                    <i data-feather="bar-chart-2" class="mr-1"></i>
                                    <span>Reports</span>
                                </li>
                                <li class="list-group-item d-flex align-items-center">
                                    <i data-feather="file-text" class="mr-1"></i>
                                    <span>Documents</span>
                                </li>
                                <li class="list-group-item d-flex align-items-center">
                                    <i data-feather="settings" class="mr-1"></i>
                                    <span>Settings</span>
                                </li>
                                <li class="list-group-item d-flex align-items-center">
                                    <i data-feather="log-out" class="mr-1"></i>
                                    <span>Logout</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Implementation Considerations</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">Progressive Enhancement</h5>
                                <ul>
                                    <li>Core functionality works without JavaScript</li>
                                    <li>Enhanced experience with JavaScript enabled</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <h5 class="card-title">Accessibility</h5>
                                <ul>
                                    <li>All forms include proper labels and ARIA attributes</li>
                                    <li>Keyboard navigation supported throughout</li>
                                    <li>Color contrast meets WCAG standards</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">Error Handling</h5>
                                <ul>
                                    <li>Clear validation messages on forms</li>
                                    <li>Graceful error recovery</li>
                                    <li>Helpful guidance for resolving issues</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-warning">
                            <div class="card-body">
                                <h5 class="card-title">Performance</h5>
                                <ul>
                                    <li>Lazy loading for reports and large data sets</li>
                                    <li>Pagination for long lists</li>
                                    <li>Optimized API calls</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
