@props([
    'error' => null,
])

<div x-data="{
    range: @entangle($attributes->wire('model')).live,
    init() {
        this.$nextTick(() => {
            const picker = flatpickr(this.$refs.input, {
                mode: 'range',
                dateFormat: 'Y-m-d',
                defaultDate: this.getDefaultDates(),
                onChange: (selectedDates) => {
                    this.updateRange(selectedDates);
                }
            });

            // Update flatpickr when Livewire changes dates
            this.$watch('range', (value) => {
                if (!value) return;
                const currentDates = picker.selectedDates;
                const shouldUpdate = (
                    (value.start && (!currentDates[0] || this.formatDate(currentDates[0]) !== value.start)) ||
                    (value.end && (!currentDates[1] || this.formatDate(currentDates[1]) !== value.end))
                );

                if (shouldUpdate) {
                    picker.setDate([value.start, value.end].filter(Boolean));
                }
            }, { deep: true });
        });
    },
    getDefaultDates() {
        if (this.range?.start && this.range?.end) {
            return [this.range.start, this.range.end];
        }
        return null;
    },
    updateRange(selectedDates) {
        if (selectedDates.length === 2) {
            this.range = {
                start: this.formatDate(selectedDates[0]),
                end: this.formatDate(selectedDates[1])
            };
        } else {
            this.range = { start: null, end: null };
        }
    },
    formatDate(date) {
        if (!date) return null;
        if (typeof date === 'string') return date;
        return date.toISOString().split('T')[0];
    }
}">
    <input {{ $attributes->whereDoesntStartWith('wire:model') }} x-ref="input" type="text" class="form-control"
        placeholder="Select date range" />
</div>
