@once
    @push('scripts')
        <script>
            (function() {
                // 1. First check if all required scripts are already loaded
                if (typeof jQuery !== 'undefined' && typeof jQuery.ui !== 'undefined' && typeof elFinder !== 'undefined') {
                    return;
                }

                // 2. Load what's missing in proper order
                const loadScript = (url) => {
                    return new Promise((resolve, reject) => {
                        const script = document.createElement('script');
                        script.src = url;
                        script.onload = resolve;
                        script.onerror = reject;
                        document.body.appendChild(script);
                    });
                };

                const loadDependencies = async () => {
                    try {
                        if (typeof jQuery === 'undefined') {
                            await loadScript("{{ asset('vendor/jquery.min.js') }}");
                        }
                        if (typeof jQuery.ui === 'undefined') {
                            await loadScript(
                                "https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.2/jquery-ui.min.js");
                        }
                        if (typeof elFinder === 'undefined') {
                            await loadScript("{{ asset('packages/barryvdh/elfinder/js/elfinder.min.js') }}");
                        }
                    } catch (error) {
                        console.error('Failed to load elFinder dependencies:', error);
                    }
                };

                // Start loading when Livewire is ready
                if (window.livewire) {
                    loadDependencies();
                } else {
                    document.addEventListener('livewire:load', loadDependencies);
                }
            })
            ();
        </script>
    @endpush
@endonce
