<div wire:ignore x-data="{
    select2Instance: null,
    currentValue: @entangle($attributes->wire('model')),
    statusClasses: {
        'active': 'text-green-600',
        'expired': 'text-red-600',
        'no-contract': 'text-gray-500'
    },

    init() {
        this.$nextTick(() => {
            this.initSelect2();
            if (this.currentValue) {
                this.select2Instance.val(this.currentValue).trigger('change');
            }
        });

        this.$watch('currentValue', (value) => {
            if (this.select2Instance && value !== undefined) {
                this.select2Instance.val(value).trigger('change');
            }
        });

        Livewire.on('refresh-select2', (dataArray) => {
            dataArray.forEach(data => {
                if (data.target === '{{ $attributes->wire('model')->value() }}') {
                    this.refreshOptions(data.options);
                }
            });
        });
    },

    initSelect2() {
        this.select2Instance = $(this.$refs.select).select2({
            minimumResultsForSearch: 0,
            dropdownParent: $(this.$refs.select).closest('.select2_content'),
            width: '100%',
            templateResult: this.formatOption.bind(this),
            templateSelection: this.formatSelection.bind(this)
        });
        this.select2Instance.on('select2:focus', () => {
            this.select2Instance.select2('open');
        });
        this.select2Instance.on('change', () => {
            const value = this.select2Instance.val();
            this.currentValue = value;
            @this.set('{{ $attributes->wire('model')->value() }}', value, true);
        });
    },

    formatOption(option) {
        if (!option.id) return option.text; // for the placeholder

        const status = $(option.element).data('status');
        const statusClass = this.statusClasses[status] || '';

        return $('<span>')
            .addClass(statusClass)
            .text(option.text);
    },

    formatSelection(option) {
        if (!option.id) return option.text; // for the placeholder

        const status = $(option.element).data('status');
        const statusClass = this.statusClasses[status] || '';

        return $('<span>')
            .addClass(statusClass)
            .text(option.text);
    },

    refreshOptions(options) {
        console.log('Refreshing with options:', options);

        const currentValue = this.currentValue;

        if (this.select2Instance) {
            this.select2Instance.select2('destroy');
        }

        const select = this.$refs.select;
        select.innerHTML = '';

        const defaultOption = document.createElement('option');
        defaultOption.value = '';
        defaultOption.textContent = '{{ $attributes->get('placeholder', 'Select Option') }}';
        select.appendChild(defaultOption);

        options.forEach(option => {
            const opt = document.createElement('option');
            opt.value = option.id;
            opt.textContent = option.text;
            opt.dataset.status = option.status || 'no-contract';
            opt.selected = (option.id == currentValue);
            select.appendChild(opt);
        });

        this.initSelect2();

        if (currentValue && options.some(opt => opt.id == currentValue)) {
            this.$nextTick(() => {
                this.select2Instance.val(currentValue).trigger('change');
            });
        }

        if (this.$refs.select.hasAttribute('data-prevent-modal-close')) {
            $(document).on('click', '.select2-container--open', function(e) {
                e.stopPropagation();
            });
        }
    },

    destroy() {
        if (this.select2Instance) {
            this.select2Instance.off('change').select2('destroy');
        }
    }
}">
    <select x-ref="select" {{ $attributes->merge(['class' => 'form-control'])->except('wire:model') }}>
        {{ $slot }}
    </select>
</div>
