<div wire:ignore x-data="{
    select2Instance: null,
    currentValue: @entangle($attributes->wire('model')),
    isMultiple: {{ $attributes->has('multiple') ? 'true' : 'false' }},
    isUpdating: false, // New flag to prevent infinite loops

    init() {
        console.log('Initializing Select2 for model:', '{{ $attributes->wire('model')->value() }}');

        this.$nextTick(() => {
            this.initSelect2();
            if (this.currentValue) {
                this.safeSetSelect2Value(this.currentValue);
            }
        });

        this.$watch('currentValue', (value) => {
            if (!this.isUpdating && this.select2Instance && value !== undefined) {
                this.safeSetSelect2Value(value);
            }
        });

        Livewire.on('refresh-select2', (dataArray) => {
            dataArray.forEach(data => {
                if (data.target === '{{ $attributes->wire('model')->value() }}') {
                    this.refreshOptions(data.options);
                }
            });
        });
    },

    initSelect2() {
        const config = {
            minimumResultsForSearch: 0,
            dropdownParent: $(this.$refs.select).closest('.select2_content'),
            width: '100%'
        };

        if (this.isMultiple) {
            config.closeOnSelect = false;
            config.placeholder = '{{ $attributes->get('placeholder', 'Select Options') }}';
        }

        this.select2Instance = $(this.$refs.select).select2(config);

        this.select2Instance.on('change', () => {
            this.isUpdating = true;
            const value = this.select2Instance.val();
            this.currentValue = value;
            @this.set('{{ $attributes->wire('model')->value() }}', value, true);
            this.isUpdating = false;
        });
    },

    safeSetSelect2Value(value) {
        if (this.select2Instance) {
            // Convert to array if multiple select expects array but gets string
            if (this.isMultiple && !Array.isArray(value)) {
                value = value ? [value] : [];
            }
            // Convert to null if single select gets empty array
            if (!this.isMultiple && Array.isArray(value)) {
                value = value.length > 0 ? value[0] : null;
            }

            this.select2Instance.val(value).trigger('change');
        }
    },

    refreshOptions(options) {
        const currentValue = this.currentValue;

        if (this.select2Instance) {
            this.select2Instance.select2('destroy');
        }

        const select = this.$refs.select;
        select.innerHTML = '';

        if (!this.isMultiple) {
            const defaultOption = document.createElement('option');
            defaultOption.value = '';
            defaultOption.textContent = '{{ $attributes->get('placeholder', 'Select Option') }}';
            select.appendChild(defaultOption);
        }

        options.forEach(option => {
            const opt = document.createElement('option');
            opt.value = option.id;
            opt.textContent = option.text;

            if (this.isMultiple && Array.isArray(currentValue)) {
                opt.selected = currentValue.includes(option.id.toString());
            } else {
                opt.selected = (option.id.toString() === currentValue?.toString());
            }

            select.appendChild(opt);
        });

        this.initSelect2();

        if (currentValue) {
            this.$nextTick(() => {
                this.safeSetSelect2Value(currentValue);
            });
        }

        if (this.$refs.select.hasAttribute('data-prevent-modal-close')) {
            $(document).on('click', '.select2-container--open', function(e) {
                e.stopPropagation();
            });
        }
    },

    destroy() {
        if (this.select2Instance) {
            this.select2Instance.off('change').select2('destroy');
        }
    }
}">
    <select x-ref="select" {{ $attributes->merge(['class' => 'form-control'])->except('wire:model') }}
        {{ $attributes->has('multiple') ? 'multiple' : '' }}>
        {{ $slot }}
    </select>
</div>
