<div x-data="{
    rawValue: '',
    entangledValue: @entangle($attributes->wire('model')),

    formatNumber(value) {
        if (value === null || value === undefined || value === '') return '';

        value = value.toString().replace(',', '.');
        const num = parseFloat(value);
        if (isNaN(num)) return '';

        // Check if the number is a whole number
        if (num % 1 === 0) {
            return num.toString(); // Return without decimals
        } else {
            // Format to 2 decimals if decimal part exists
            return num;
        }
    },

    init() {
        // Initialize display
        if (this.entangledValue !== null && this.entangledValue !== undefined && this.entangledValue !== '') {
            this.rawValue = this.formatNumber(this.entangledValue);
        }

        // Watch for Livewire changes and update display
        this.$watch('entangledValue', (newValue) => {
            if (newValue !== null && newValue !== undefined && newValue !== '') {
                this.rawValue = this.formatNumber(newValue);
            } else {
                this.rawValue = '';
            }
        });
    }
}">
    <input type="text" x-model="rawValue" {{ $attributes->class('form-control')->merge(['type' => 'text']) }}
        @input="
                rawValue = rawValue
                    .replace(/[^0-9,.]/g, '')
                    .replace(/(\..*)\./g, '$1')
                    .replace(/(,.*),/g, '$1');

                // If input is empty, clear the Livewire property immediately
                if (rawValue === '') {
                    entangledValue = null;
                }
           "
        @blur="
                if (rawValue) {
                    const num = parseFloat(rawValue.replace(',', '.'));
                    if (!isNaN(num)) {
                        // Format based on whether it's a whole number
                        rawValue = num % 1 === 0 ? num.toString() : num;
                        entangledValue = num; // update Livewire
                    } else {
                        rawValue = '';
                        entangledValue = null;
                    }
                } else {
                    entangledValue = null; // clear Livewire when empty
                }
           "
        placeholder="{{ $attributes->get('placeholder', '0.00') }}"
        {{ $attributes->except(['wire:model', 'placeholder'])->merge(['class' => 'form-control']) }}>
</div>
