@extends('layouts/layoutMaster')

@section('title', 'Floating Action Button Demo')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Floating Action Button Demo</h4>
                        <p class="card-text">This page demonstrates the floating action button component with different
                            configurations.</p>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Default Configuration</h5>
                                <p>Basic floating action button with default settings:</p>
                                <pre><code>&lt;livewire:components.floating-action-button /&gt;</code></pre>
                            </div>
                            <div class="col-md-6">
                                <h5>Custom Configuration</h5>
                                <p>Floating action button with custom settings:</p>
                                <pre><code>&lt;livewire:components.floating-action-button :config="[
                                    'position' => 'middle-left',
                                    'theme' => 'success',
                                    'size' => 'md',
                                    'showStats' => true,
                                    'showSettings' => true,
                                    'showActivity' => true,
                                    'autoRefresh' => true,
                                    'refreshInterval' => 60000
                                ]" /&gt;</code></pre>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-md-6">
                                <h5>Configuration Options</h5>
                                <ul>
                                    <li><strong>position:</strong> bottom-right, bottom-left, top-right, top-left,
                                        middle-left, middle-right, center</li>
                                    <li><strong>theme:</strong> primary, secondary, success, danger, warning, info</li>
                                    <li><strong>size:</strong> sm, md, lg</li>
                                    <li><strong>showStats:</strong> true/false</li>
                                    <li><strong>showSettings:</strong> true/false</li>
                                    <li><strong>showActivity:</strong> true/false</li>
                                    <li><strong>autoRefresh:</strong> true/false</li>
                                    <li><strong>refreshInterval:</strong> milliseconds (default: 30000)</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h5>Custom Actions</h5>
                                <p>You can also pass custom actions:</p>
                                <pre><code>&lt;livewire:components.floating-action-button :config="[
                                    'actions' => [
                                        [
                                            'id' => 'custom-action',
                                            'title' => 'Custom Action',
                                            'icon' => 'ti ti-star',
                                            'color' => 'warning',
                                            'action' => 'customAction'
                                        ]
                                    ]
                                ]" /&gt;</code></pre>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-12">
                                <h5>Features</h5>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="text-center">
                                            <i class="ti ti-chart-bar ti-3x text-primary mb-2"></i>
                                            <h6>Real-time Stats</h6>
                                            <p class="small text-muted">Live statistics from your database</p>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="text-center">
                                            <i class="ti ti-zap ti-3x text-success mb-2"></i>
                                            <h6>Quick Actions</h6>
                                            <p class="small text-muted">Fast access to common tasks</p>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="text-center">
                                            <i class="ti ti-settings ti-3x text-warning mb-2"></i>
                                            <h6>Quick Settings</h6>
                                            <p class="small text-muted">Toggle preferences instantly</p>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="text-center">
                                            <i class="ti ti-clock ti-3x text-info mb-2"></i>
                                            <h6>Recent Activity</h6>
                                            <p class="small text-muted">Latest system activities</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Demo floating action button -->
    <livewire:components.floating-action-button :config="[
        'position' => 'middle-left',
        'theme' => 'primary',
        'size' => 'lg',
        'showStats' => true,
        'showSettings' => true,
        'showActivity' => true,
        'autoRefresh' => false,
        'refreshInterval' => 30000,
    ]" />
@endsection
