<!-- BEGIN: Vendor JS-->
@vite('resources/js/app.js')
@vite(['resources/assets/vendor/libs/jquery/jquery.js', 'resources/assets/vendor/libs/popper/popper.js', 'resources/assets/vendor/js/bootstrap.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/node-waves/node-waves.js', 'resources/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js', 'resources/assets/vendor/libs/hammer/hammer.js', 'resources/assets/vendor/libs/typeahead-js/typeahead.js', 'resources/assets/vendor/js/menu.js', 'resources/assets/vendor/libs/toastr/toastr.js'])
@vite(['resources/assets/vendor/libs/block-ui/block-ui.js'])
@vite(['resources/js/Mulk/Shared/shared.js'])
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.3/html2pdf.bundle.min.js"></script>
<script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
@vite('resources/js/Transfer/Transfer/index.js')



<script type="text/javascript" src="{{ asset('vendor/rappasoft/livewire-tables/js/laravel-livewire-tables.min.js') }}">
</script>



<script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.11/dist/clipboard.min.js"></script>

<script>
    document.addEventListener('focus-error', function(e) {
        let fieldName = e.detail[0].field;

        // Match multiple wire:model variations
        let inputEl = document.querySelector(
            `[wire\\:model="${fieldName}"],
         [wire\\:model\\.lazy="${fieldName}"],
         [wire\\:model\\.debounce\\.500ms="${fieldName}"]`
        );

        if (inputEl) {
            inputEl.focus();

            // Force animation restart
            inputEl.classList.remove('input-error-shake');
            void inputEl.offsetWidth; // reflow
            inputEl.classList.add('input-error-shake');
        }
    });
</script>


<script>
    var clipboard = new ClipboardJS('.clipboard');

    clipboard.on('success', function(e) {
        toastr['success']('Text copied to clipboard', 'Success!', {
            closeButton: true,
            tapToDismiss: false,
        })
    });

    // Handle error event
    clipboard.on('error', function(e) {
        alert('Failed to copy text.');
    });
</script>
<script>
    document.getElementById('screenshotBtn').addEventListener('click', async () => {
        const target = document.getElementById('mutabaka');

        // Hide all buttons in the target div
        const buttons = target.querySelectorAll('button');
        const originalStyles = [];

        // Store original styles and hide buttons
        buttons.forEach((button, index) => {
            originalStyles[index] = {
                display: button.style.display || 'inline-block',
                visibility: button.style.visibility || 'visible',
                opacity: button.style.opacity || '1',
                position: button.style.position || 'static',
                left: button.style.left || 'auto'
            };
            button.style.display = 'none';
            button.style.visibility = 'hidden';
            button.style.opacity = '0';
        });

        // Also hide the button container row if it exists
        const buttonRow = target.querySelector('.row:first-child');
        let originalRowStyle = null;
        if (buttonRow) {
            originalRowStyle = {
                display: buttonRow.style.display || 'flex',
                visibility: buttonRow.style.visibility || 'visible',
                opacity: buttonRow.style.opacity || '1',
                position: buttonRow.style.position || 'static',
                left: buttonRow.style.left || 'auto'
            };
            buttonRow.style.display = 'none';
            buttonRow.style.visibility = 'hidden';
            buttonRow.style.opacity = '0';
        }

        // Wait a bit for the DOM to update
        await new Promise(resolve => setTimeout(resolve, 100));

        // Additional aggressive hiding as fallback
        buttons.forEach(button => {
            button.style.setProperty('display', 'none', 'important');
            button.style.setProperty('visibility', 'hidden', 'important');
            button.style.setProperty('opacity', '0', 'important');
            button.style.setProperty('position', 'absolute', 'important');
            button.style.setProperty('left', '-9999px', 'important');
        });

        if (buttonRow) {
            buttonRow.style.setProperty('display', 'none', 'important');
            buttonRow.style.setProperty('visibility', 'hidden', 'important');
            buttonRow.style.setProperty('opacity', '0', 'important');
            buttonRow.style.setProperty('position', 'absolute', 'important');
            buttonRow.style.setProperty('left', '-9999px', 'important');
        }

        // Wait again for aggressive hiding to take effect
        await new Promise(resolve => setTimeout(resolve, 200));

        html2canvas(target, {
            useCORS: true,
            scale: 2,
            allowTaint: true,
            backgroundColor: null
        }).then(async canvas => {
            console.log('Screenshot taken, restoring buttons...');

            // Restore all buttons to their original state with !important to override aggressive hiding
            buttons.forEach((button, index) => {
                if (originalStyles[index]) {
                    button.style.setProperty('display', originalStyles[index].display,
                        'important');
                    button.style.setProperty('visibility', originalStyles[index]
                        .visibility, 'important');
                    button.style.setProperty('opacity', originalStyles[index].opacity,
                        'important');
                    button.style.setProperty('position', originalStyles[index].position,
                        'important');
                    button.style.setProperty('left', originalStyles[index].left,
                        'important');
                }
            });

            // Restore button row if it was hidden with !important
            if (buttonRow && originalRowStyle) {
                buttonRow.style.setProperty('display', originalRowStyle.display, 'important');
                buttonRow.style.setProperty('visibility', originalRowStyle.visibility,
                    'important');
                buttonRow.style.setProperty('opacity', originalRowStyle.opacity, 'important');
                buttonRow.style.setProperty('position', originalRowStyle.position, 'important');
                buttonRow.style.setProperty('left', originalRowStyle.left, 'important');
            }

            console.log('Buttons restored successfully');

            canvas.toBlob(async blob => {
                try {
                    // Check if clipboard API is available
                    if (!navigator.clipboard || !navigator.clipboard.write) {
                        toastr.error(
                            '❌ Clipboard API not supported in your browser. Try Chrome with HTTPS.',
                            '', {
                                timeOut: 3000,
                                closeButton: true,
                                progressBar: true
                            });
                        return;
                    }

                    // ClipboardItem fallback if needed
                    if (typeof ClipboardItem === "undefined") {
                        window.ClipboardItem = function(items) {
                            return {
                                [Symbol.toStringTag]: "ClipboardItem",
                                types: Object.keys(items),
                                getType: (type) => Promise.resolve(items[type])
                            };
                        };
                    }

                    const item = new ClipboardItem({
                        'image/png': blob
                    });
                    await navigator.clipboard.write([item]);
                    toastr.success('📸 تم نسخ صورة المطابقة بنجاح إلى الحافظة!',
                        '', {
                            timeOut: 3000,
                            closeButton: true,
                            progressBar: true
                        });
                } catch (err) {
                    toastr.error(
                        '⚠️ فشل النسخ إلى الحافظة. تأكد من استخدام HTTPS أو استخدم متصفح يدعمه.',
                        '', {
                            timeOut: 3000,
                            closeButton: true,
                            progressBar: true
                        });
                    console.error(err);
                }
            });
        }).catch(error => {
            console.error('Screenshot error:', error);
            console.log('Restoring buttons due to error...');

            // Restore buttons even if screenshot fails
            buttons.forEach((button, index) => {
                if (originalStyles[index]) {
                    button.style.setProperty('display', originalStyles[index].display,
                        'important');
                    button.style.setProperty('visibility', originalStyles[index].visibility,
                        'important');
                    button.style.setProperty('opacity', originalStyles[index].opacity,
                        'important');
                    button.style.setProperty('position', originalStyles[index].position,
                        'important');
                    button.style.setProperty('left', originalStyles[index].left,
                        'important');
                }
            });

            if (buttonRow && originalRowStyle) {
                buttonRow.style.setProperty('display', originalRowStyle.display, 'important');
                buttonRow.style.setProperty('visibility', originalRowStyle.visibility, 'important');
                buttonRow.style.setProperty('opacity', originalRowStyle.opacity, 'important');
                buttonRow.style.setProperty('position', originalRowStyle.position, 'important');
                buttonRow.style.setProperty('left', originalRowStyle.left, 'important');
            }

            console.log('Buttons restored after error');
        });

        // Safety fallback: ensure buttons are restored after 5 seconds no matter what
        setTimeout(() => {
            console.log('Safety fallback: restoring buttons...');
            buttons.forEach((button, index) => {
                if (originalStyles[index]) {
                    button.style.setProperty('display', originalStyles[index].display,
                        'important');
                    button.style.setProperty('visibility', originalStyles[index].visibility,
                        'important');
                    button.style.setProperty('opacity', originalStyles[index].opacity,
                        'important');
                    button.style.setProperty('position', originalStyles[index].position,
                        'important');
                    button.style.setProperty('left', originalStyles[index].left,
                        'important');
                }
            });

            if (buttonRow && originalRowStyle) {
                buttonRow.style.setProperty('display', originalRowStyle.display, 'important');
                buttonRow.style.setProperty('visibility', originalRowStyle.visibility, 'important');
                buttonRow.style.setProperty('opacity', originalRowStyle.opacity, 'important');
                buttonRow.style.setProperty('position', originalRowStyle.position, 'important');
                buttonRow.style.setProperty('left', originalRowStyle.left, 'important');
            }

            console.log('Safety fallback completed');
        }, 5000);
    });
</script>
<script>
    window.addEventListener('DOMContentLoaded', function() {
        const agentId = @json(auth()->guard('agent')->id());
        if (window.Echo) {
            window.Echo.channel('agent-logout.' + agentId).listen('.AgentForceLogout', e => {
                alert("yes")
                fetch('/logout', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                            .getAttribute(
                                'content'),
                        Accept: 'application/json',
                        'Content-Type': 'application/json'
                    },
                    credentials: 'same-origin'
                }).then(() => {
                    window.location.href = '/login';
                });
            });
            window.Echo.channel('orange_database_RefreshDataTable')
                .listen('.RefreshDataTable', e => {
                    console.log(e);
                    var table = e.table;
                    if (window.LaravelDataTables && window.LaravelDataTables[table] !== undefined) {
                        window.LaravelDataTables[table].draw(false);
                    } else {
                        console.warn(`DataTable '${table}' not found or LaravelDataTables not defined`);
                        // Optionally reload the page as fallback
                        // window.location.reload();
                    }


                });
        } else {
            console.error("Echo not ready.");
        }
    });
</script>
<script>
    function htmlTitle(html) {
        const container = document.createElement("div");
        container.innerHTML = html;
        return container;
    }




    document.addEventListener('livewire:load', function() {


        // Show blockUI when ChangeTab starts
        Livewire.on('loadingChangeTab', () => {
            $('body').block({
                message: `
                <div class="d-flex flex-column align-items-center">
                    <div class="spinner-border text-primary" role="status"></div>
                    <h5 class="mt-2">Loading...</h5>
                </div>
            `,
                css: {
                    backgroundColor: 'transparent',
                    border: '0',
                    color: '#000',
                    width: '100%',
                },
                overlayCSS: {
                    backgroundColor: $('html').hasClass('dark-style') ? '#000' : '#fff',
                    opacity: 0.55
                }
            });
        });

        // Hide blockUI when ChangeTab finishes
        Livewire.on('loadedChangeTab', () => {
            $card.unblock();
        });
    });







    window.addEventListener('BlockUI', (event) => {

        BlockUI();
    })

    function BlockUI() {
        $.blockUI({
            message: '<div class="spinner-border text-white"></div>',
            css: {
                backgroundColor: 'transparent',
                border: '0'
            },
            overlayCSS: {
                opacity: 0.5
            }
        });
    }


    window.addEventListener('UnBlockUI', (event) => {

        $.unblockUI();
    })







    window.addEventListener('renderTopology', (event) => {


        rawNodes = event.detail[0].nodes;
        rawEdges = event.detail[0].edges;
        console.log(rawNodes);

        const styledNodes = rawNodes.map(n => ({
            ...n, // ← this keeps the `title` intact!
            title: htmlTitle(n.title),
            shape: n.shape || "box",
            color: {
                border: n.color.border || "#000000",
                background: n.color.background || "#ffffff",

            },
            borderWidth: 2,
            font: {
                multi: true,
                size: 14,
                face: "sans-serif"
            }
        }));




        // Links from parent


        const container = document.getElementById("network");
        const nodes = new vis.DataSet(styledNodes);
        const edges = new vis.DataSet(rawEdges);



        const visData = {
            nodes,
            edges
        };

        const options = {
            interaction: {
                hover: true,
                tooltipDelay: 100
            },
            physics: {
                enabled: true,
                solver: "forceAtlas2Based",
                forceAtlas2Based: {
                    gravitationalConstant: -150, // stronger repulsion
                    centralGravity: 0.01,
                    springLength: 200, // spacing between nodes
                    springConstant: 0.08
                },
                stabilization: {
                    enabled: true,
                    iterations: 1000,
                    updateInterval: 25
                }
            },
            layout: {
                randomSeed: 42 // keep same layout each render
            },
            interaction: {
                hover: true,
                tooltipDelay: 100
            },
            nodes: {
                margin: 10,
                shape: "dot",
                font: {
                    size: 14,
                    face: "sans-serif"
                }
            },
            edges: {
                arrows: {
                    to: {
                        enabled: false
                    }
                },
                smooth: true
            }
        };

        const network = new vis.Network(container, visData, options);

        // On node click
        network.on("click", function(params) {
            if (params.nodes.length > 0) {
                const clickedNode = nodes.get(params.nodes[0]);
                if (clickedNode.url) {
                    window.location.href = clickedNode.url;
                }
            }
        });
        network.once("stabilizationIterationsDone", function() {
            network.fit({
                animation: {
                    duration: 1000,
                    easingFunction: "easeInOutQuad"
                }
            });
        });
        const popover = document.getElementById("nodePopover");
        const popoverContent = document.getElementById("popoverContent");

        network.on("hoverNode", function(params) {
            const node = nodes.get(params.node);

            // Set content
            popoverContent.innerHTML = `
<strong>${node.label}</strong><br>
${node.tenant}<br>

`;

            // Get canvas position
            const canvasPosition = network.getBoundingBox(params.node);
            const containerRect = container.getBoundingClientRect();

            const x = params.event?.srcEvent?.clientX || 0;
            const y = params.event?.srcEvent?.clientY || 0;

            popover.style.left = `${x + 10}px`;
            popover.style.top = `${y + 10}px`;
            popover.style.display = "block";
        });
    });
</script>
<script>
    window.addEventListener("toastr:success", event => {
        const detail = event.detail[0]; // Livewire sends an array
        const message = detail.msg;
        const reference = detail.reference;
        const position = detail.position || 'bottom-center';
        const htmlMessage = `
          ${message}
          <button style="margin-left:10px; padding:2px 6px; font-size:12px;"
              onclick="
                  if (navigator.clipboard && navigator.clipboard.writeText) {
                      navigator.clipboard.writeText('${message} ${reference}')
                          .then(() => {
                              toastr.options.positionClass = 'toast-${position}';
                              toastr.info('Message copied to clipboard');
                          })
                          .catch(() => {
                              toastr.options.positionClass = 'toast-${position}';
                              toastr.error('Failed to copy to clipboard');
                          });
                  } else {
                      toastr.options.positionClass = 'toast-${position}';
                      toastr.error('Clipboard API not supported');
                  }
              ">
              📋 نسخ
          </button>
      `;

        // Set toastr options including position
        toastr.options.escapeHtml = false; // allow HTML
        toastr.options.positionClass = `toast-${position}`; // Set position

        toastr.success(htmlMessage, '', {
            timeOut: 5000,
            closeButton: true,
            tapToDismiss: false,
            preventDuplicates: true,
            progressBar: true,
            progressBarClass: 'bg-success',
            progressBarWidth: 100,
            progressBarHeight: 10,
        });
    });

    window.addEventListener('copyToClipboard', event => {
        // Get the text from the event
        const text = event.detail[0].text;

        // Debug: log the event data
        console.log('Copy event:', event.detail);
        console.log('Text to copy:', text);

        if (!text) {
            console.error('No text to copy');
            toastr.error('No credentials to copy', 'Error');
            return;
        }

        if (navigator.clipboard && navigator.clipboard.writeText) {
            // Use modern clipboard API
            navigator.clipboard.writeText(text).then(() => {
                // Show success message
                toastr.success('Credentials copied to clipboard!', 'Success');
            }).catch(err => {
                console.error('Failed to copy: ', err);
                toastr.error('Failed to copy credentials', 'Error');
            });
        } else {
            // Fallback for older browsers
            const textArea = document.createElement('textarea');
            textArea.value = text;
            textArea.style.position = 'fixed';
            textArea.style.left = '-999999px';
            textArea.style.top = '-999999px';
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                document.execCommand('copy');
                toastr.success('Credentials copied to clipboard!', 'Success');
            } catch (err) {
                console.error('Failed to copy: ', err);
                toastr.error('Failed to copy credentials', 'Error');
            }

            document.body.removeChild(textArea);
        }
    });
    window.addEventListener("toastr:error", event => {
        const detail = event.detail[0];
        const message = detail.msg;
        const position = detail.position || 'top-right';

        // Set toastr options including position
        toastr.options.positionClass = `toast-${position}`; // Set position

        toastr.error(message);
    });
    window.addEventListener("open_modal", event => {

        var action = event.detail[0].action;

        $("#" + event.detail[0].id).modal(action);
    });
    window.addEventListener("showFeather", event => {
        feather.replace()
    });
    window.addEventListener("initializeLeafletMap", event => {
        initializeLeafletMap()
    });
    window.addEventListener("RefreshDatatable", event => {
        var table = event.detail.table;
        var tablename = $("#" + table);
        tablename.DataTable().ajax.reload();
    });
    window.addEventListener("RefreshYajraDatatable", event => {
        try {
            $.unblockUI();

            var table = event.detail[0].table;
            console.log(table);

            // Check if LaravelDataTables exists and has the table
            if (window.LaravelDataTables && window.LaravelDataTables[table] !== undefined) {
                window.LaravelDataTables[table].draw();
            } else {
                console.warn(`DataTable '${table}' not found or LaravelDataTables not defined`);
                // Optionally reload the page as fallback
                // window.location.reload();
            }
        } catch (error) {
            console.error("Error refreshing DataTable:", error);
        }
    });

    window.addEventListener("sweetalert:success", event => {

        var msg = event.detail[0].msg;
        var title = event.detail[0].title;

        Swal.fire({
            title: title,
            text: msg,
            icon: 'success',
            customClass: {
                confirmButton: 'btn btn-primary waves-effect waves-light'
            },
            buttonsStyling: false


        })
    })
    window.addEventListener("sweetalert:error", event => {

        var msg = event.detail[0].msg;
        var title = event.detail[0].title;

        Swal.fire({
            title: title,
            text: msg,
            icon: 'error',
            customClass: {
                confirmButton: 'btn btn-primary waves-effect waves-light'
            },
            buttonsStyling: false

        })
    })
    window.addEventListener("areyousure", event => {

        var msg = event.detail.msg || event.detail[0].msg;
        var title = event.detail.title || event.detail[0].title;
        var action = event.detail.action || event.detail[0].action;
        var emitname = event.detail.emitName || event.detail[0].emitName;
        var data = event.detail.data || event.detail[0].data;

        Swal.fire({
            title: title,
            text: msg,

            icon: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#3085d6',

            confirmButtonText: action,

        }).then((result) => {

            if (result.isConfirmed) {
                BlockUI();
                Livewire.dispatch(emitname, {
                    data: data
                })
            }

        })
    });
</script>
@yield('vendor-script')
<!-- END: Page Vendor JS-->
<!-- BEGIN: Theme JS-->
@vite(['resources/assets/js/main.js'])

<!-- END: Theme JS-->
<!-- Pricing Modal JS-->
@stack('pricing-script')
<!-- END: Pricing Modal JS-->
<!-- BEGIN: Page JS-->
@yield('page-script')
<script>
    window.addEventListener('initElfinder', function(event) {
        var modelname = event.detail[0].modelname;
        var modelid = event.detail[0].modelid;

        var $j = jQuery.noConflict();
        var baseUrl = '{{ route('elfinder.connector', ['modelname' => ':modelname', 'id' => ':id']) }}';
        var finalUrl = baseUrl
            .replace(':modelname', encodeURIComponent(modelname))
            .replace(':id', encodeURIComponent(modelid));
        $('#elfinder-container').elfinder({
            // Custom setup
            lang: '{{ config('elfinder.locale') }}',
            customData: {
                _token: '{{ csrf_token() }}'
            },
            customData: {
                _token: '{{ csrf_token() }}',
                modelname: modelname, // Also pass in customData if needed
                modelid: modelid
            },
            url: finalUrl, // Use the constructed URL
            defaultView: 'list',
            height: 500, // Adjust height as needed
            uiOptions: {
                toolbar: [
                    ['back', 'forward'],
                    ['reload'],
                    ['home', 'up'],
                    ['mkdir', 'mkfile', 'upload'],
                    ['open', 'download', 'getfile'],
                    ['info'],
                    ['quicklook'],
                    ['copy', 'cut', 'paste'],
                    ['rm'],
                    ['duplicate', 'rename', 'edit'],
                    ['search'],
                    ['view', 'sort']
                ]
            }
        }).elfinder('instance');
    });
</script>

<script>
    window.addEventListener('filtersApplied', function(event) {
        const data = event.detail[0];
        var table_id = data.table_id;
        console.log(data.filters);
        try {
            const table = window.LaravelDataTables[table_id];
            if (table) {
                // Stringify the filters object before storing
                window.filters = JSON.parse(JSON.stringify(data.filters));

                // Force a full reload

                table.ajax.reload();

            }
        } catch (e) {
            console.log(e);
        }
    });
    window.addEventListener('scrollToForm', function(event) {

        const data = event.detail[0];
        var form_id = data.form_id;
        var form = document.getElementById(form_id);

        if (form) {
            form.scrollIntoView({
                behavior: 'smooth'
            });

        }
    });
</script>
<!-- END: Page JS-->

@stack('modals')
@laravelTelInputScripts
{!! phone_input_js() !!}

@livewireScripts
