<div>
    <style>
        .config-form label,
        .config-form small,
        .config-form th,
        .config-form td,
        .config-form input,
        .config-form {
            font-size: 1rem;
            /* ~16px, bigger text */
            font-weight: 600;
            /* semi-bold */
        }

        .config-form th {
            background-color: #f8f9fa;
        }

        .config-form .form-control-sm {
            font-size: 1rem;
            /* match other text */
            font-weight: 600;
        }

        .config-form .switch {
            transform: scale(1.2);
            /* make switches slightly bigger */
        }
    </style>

    <div class="row config-form">
        <div class="col-md-3">
            <div class="row g-2">
                <div class="col-6">
                    <label class="switch w-100 d-flex justify-content-between align-items-center">
                        <input type="checkbox" wire:model.live="global.send_transfer" class="switch-input">
                        <span class="switch-toggle-slider">
                            <span class="switch-on">ON</span>
                            <span class="switch-off">OFF</span>
                        </span>
                    </label>
                    <small class="d-block text-center mt-1">ظهور صادر</small>
                </div>
                <div class="col-6">
                    <label class="switch w-100 d-flex justify-content-between align-items-center">
                        <input type="checkbox" wire:model.lazy="global.send_approval" class="switch-input">
                        <span class="switch-toggle-slider">
                            <span class="switch-on">ON</span>
                            <span class="switch-off">OFF</span>
                        </span>
                    </label>
                    <small class="d-block text-center mt-1">ظهور اعتماد</small>
                </div>
            </div>
        </div>

        <div class="col-md-9">
            <div class="row mb-2">
                <div class="col-4">
                    <label>مقوم حوالات</label>
                    <div class="d-flex align-items-center ml-2">

                        <input type="number" class="form-control form-control-sm"
                            wire:model.lazy="global.base_credit_limit" step="0.01">
                        <div>
                            <label class="switch m-0">
                                <input type="checkbox" wire:model.live="global.transfer_status" class="switch-input">
                                <span class="switch-toggle-slider">
                                    <span class="switch-on">ON</span>
                                    <span class="switch-off">OFF</span>
                                </span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="col-4 mr-4">
                    <label>مقوم اعتماد</label>
                    <input type="number" class="form-control form-control-sm"
                        wire:model.lazy="global.approval_credit_limit" step="0.01">
                </div>
            </div>

            <table class="table table-sm table-bordered">
                <thead>
                    <tr>
                        <th>العملة</th>
                        <th>صادر</th>
                        <th>وارد</th>
                        <th>حد المديونية</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($currencies as $currency)
                        <tr>
                            <td>{{ $currency->name }}</td>
                            <td class="text-center">
                                <label class="switch">
                                    <input type="checkbox" class="switch-input"
                                        wire:model.live="visibility.{{ $currency->code }}.send">
                                    <span class="switch-toggle-slider">
                                        <span class="switch-on">on</span>
                                        <span class="switch-off">off</span>
                                    </span>
                                </label>
                            </td>
                            <td class="text-center">
                                <label class="switch">
                                    <input type="checkbox" class="switch-input"
                                        wire:model.live="visibility.{{ $currency->code }}.receive">
                                    <span class="switch-toggle-slider">
                                        <span class="switch-on">on</span>
                                        <span class="switch-off">off</span>
                                    </span>
                                </label>
                            </td>
                            <td>
                                <input type="number" step="0.01"
                                    wire:model.lazy="currecnyCreditLimit.{{ $currency->code }}.credit_limit"
                                    class="form-control form-control-sm">
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
    @include('livewire.credit-settings-modal')
</div>
