<div class="col-xl-7 col-lg-7 col-md-6">



    <div class="row">

        <div class="col-xl-12">
            <!-- Activity Timeline -->
            <div class="card card-action mb-4">

                <div class="card-body pb-0">
                    <form>

                        <div class="row g-3">
                            <div class="col-md-6 select2_content">
                                <label class="form-label">
                                    {{ __('transfers.reference') }}:
                                </label>

                                <div class=" w-100">

                                    <div class="flex-grow-1">
                                        <input type="text" class="form-control" wire:model="transfer.reference"
                                            placeholder="{{ __('transfers.reference') }}" />
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-6 select2_content">
                                <label class="form-label">
                                    {{ __('transfers.secret') }}:
                                </label>

                                <div class=" w-100">

                                    <div class="flex-grow-1">
                                        <input type="text" class="form-control" wire:model.lazy="transfer.secret"
                                            placeholder="{{ __('transfers.secret') }}" />
                                    </div>

                                </div>
                            </div>
                            <div class="d-grid gap-2 col-6 mx-auto">

                                <button class="btn btn-primary " type="button" wire:click="searchTransfer">بحث
                                </button>

                            </div>
                        </div>
                    </form>
                    @if ($add_client)
                        @livewire('client.add')
                    @else
                        <form class="card-body" wire:submit.prevent="deliverTransfer">

                            <div class="row g-3">




                                @if ($selected_transfer)

                                    @if (isset($transfer['type']) && $transfer['type'] == 'transfer')
                                        <div class="col-md-6">
                                            <label class="form-label">اسم المرسل </label>
                                            <input type="text" class="form-control" readonly
                                                wire:model="transfer.client.name.{{ app()->getLocale() }}" />
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">هاتف المرسل </label>
                                            <input type="text" class="form-control phone-mask" readonly
                                                wire:model="transfer.client.phone" />
                                        </div>



                                        <div class="col-md-6">
                                            <label class="form-label">اسم المستفيد </label>
                                            <input type="text" class="form-control" readonly
                                                wire:model="transfer.recipient_name" />
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">هاتف المستفيد </label>
                                            <input type="text" class="form-control phone-mask" readonly
                                                wire:model="transfer.recipient_phone" />
                                        </div>
                                    @endif

                                    <div class="col-md-6">
                                        <label class="form-label"> المبلغ </label>
                                        <input type="text" class="form-control" readonly
                                            value="{!! $transfer['amount_number'] !!}" />
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">المبلغ كتابة </label>
                                        <input type="text" class="form-control" wire:model="transfer.written_amount"
                                            readonly />
                                    </div>




                                    <div class="col-md-6">
                                        <label class="form-label"> تاريخ التحويل </label>
                                        <input type="text" class="form-control  " readonly
                                            wire:model="transfer.created_at" />
                                    </div>


                                    <div class="col-md-6">
                                        <label class="form-label"> سبب التحويل </label>
                                        <input type="text" class="form-control" readonly
                                            wire:model="transfer.reason_name" />
                                    </div>

                                    <hr />
                                    @if (isset($transfer['type']) && $transfer['type'] == 'transfer')
                                        <div class="col-md-12 select2_content">
                                            <label class="form-label">الرقم الوطني للمستفيد :</label>

                                            <div class="input-group w-100">
                                                {{-- Make sure this renders an <input class="form-control"> inside --}}
                                                <div class="flex-grow-1">
                                                    <x-Mulk.live_search wire:model="recipient.identity_number"
                                                        search-url="/Clients/Search" :search-url="$clientsSearchUrl"
                                                        placeholder="{{ __('transfers.national_id_placeholder') }}" />
                                                </div>
                                                <button class="btn btn-outline-primary" type="button"
                                                    x-on:click="$dispatch('AddNewClientEvent')">
                                                    {{ __('general.add') }}
                                                </button>
                                            </div>

                                            @error('recipient.identity_number')
                                                <span class="text-danger"> {{ $message }}
                                                </span>
                                            @enderror
                                        </div>
                                    @endif




                                @endif

                            </div>

                            @if ($selected_transfer)
                                @livewire('components.attachments-repeater')


                                <br />
                                <div class="d-grid gap-2 col-6 mx-auto">
                                    <button class="btn btn-primary " type="submit">تسليم الحوالة</button>

                                </div>
                            @endif


                        </form>
                    @endif
                </div>
            </div>
            <!--/ Activity Timeline -->
        </div>

    </div>
    <!--/ User Profile Content -->

</div>
