<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12">
            <!-- Header -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">
                        <i class="tf-icons ti ti-history me-2"></i>
                        {{ __('audit.page_title') }}
                    </h4>
                    <button type="button" class="btn btn-outline-danger" wire:click="clearFilters">
                        <i class="tf-icons ti ti-refresh me-1"></i>
                        {{ __('audit.clear_filters') }}
                    </button>
                </div>
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <div class="row g-3">
                        <!-- Date Filter -->
                        <div class="col-md-3">
                            <label class="form-label">{{ __('audit.filters.date') }}</label>
                            <input type="date" class="form-control" wire:model="selectedDate">
                        </div>

                        <!-- User Filter -->
                        <div class="col-md-3">
                            <label class="form-label">{{ __('audit.filters.user') }}</label>
                            <select class="form-select" wire:model="selectedUser">
                                <option value="">{{ __('audit.filters.all_users') }}</option>
                                @foreach ($users as $user)
                                    <option value="{{ $user['id'] }}">{{ $user['name'] }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Event Filter -->
                        <div class="col-md-2">
                            <label class="form-label">{{ __('audit.filters.event') }}</label>
                            <select class="form-select" wire:model="selectedEvent">
                                <option value="">{{ __('audit.filters.all_events') }}</option>
                                @foreach ($events as $key => $label)
                                    <option value="{{ $key }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Model Filter -->
                        <div class="col-md-2">
                            <label class="form-label">{{ __('audit.filters.model') }}</label>
                            <select class="form-select" wire:model="selectedModel">
                                <option value="">{{ __('audit.filters.all_models') }}</option>
                                @foreach ($models as $key => $label)
                                    <option value="{{ $key }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Search -->
                        <div class="col-md-2">
                            <label class="form-label">{{ __('audit.filters.search') }}</label>
                            <input type="text" class="form-control" wire:model.debounce.300ms="searchQuery"
                                placeholder="{{ __('audit.filters.search_placeholder') }}">
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-primary" wire:click="applyFilters">
                                {{ __('audit.filters.apply') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- DataTable -->

        </div>
    </div>

    <!-- Audit Details Modal -->
    @livewire('audit-logs.details')
</div>

@push('scripts')
    <script>
        // Listen for filter changes and refresh DataTable
        document.addEventListener('livewire:init', () => {
            Livewire.on('refreshAuditTable', () => {
                // Get current filter values
                const date = @this.selectedDate;
                const user = @this.selectedUser;
                const event = @this.selectedEvent;
                const model = @this.selectedModel;
                const search = @this.searchQuery;

                // Refresh DataTable with new parameters
                window.LaravelDataTables['audit-table'].ajax.reload();
            });
        });

        // Handle audit details modal
        $(document).on('click', '.view-audit-details', function() {
            const auditId = $(this).data('audit-id');
            Livewire.dispatch('showAuditDetails', {
                auditId: auditId
            });
        });
    </script>
@endpush
