<div>
    <div class="mb-4 flex flex-wrap items-center gap-4">
        <label class="inline-flex items-center">
            <input type="checkbox" wire:model="showRemittanceDetails" class="form-checkbox">
            <span class="ml-2">عرض تفاصيل الحوالات والعمولات</span>
        </label>

        @foreach ($currencies as $currency)
            <label class="inline-flex items-center">
                <input type="checkbox" wire:model="filters.currencies" value="{{ $currency }}" class="form-checkbox">
                <span class="ml-2">{{ $currency }}</span>
            </label>
        @endforeach

        <div class="ml-auto">
            <button wire:click="$toggle('showColumnSelector')" class="btn btn-secondary">
                اختر الأعمدة
            </button>

            @if ($showColumnSelector)
                <div class="absolute z-10 mt-2 w-56 bg-white shadow-lg rounded-md p-2">
                    @foreach ($columns as $key => $column)
                        @if (!in_array($key, ['account_code', 'account_name']))
                            <label class="flex items-center px-2 py-1 hover:bg-gray-100 rounded">
                                <input type="checkbox" wire:model="selectedColumns" value="{{ $key }}"
                                    class="form-checkbox">
                                <span class="ml-2">{{ $column['title'] }}</span>
                            </label>
                        @endif
                    @endforeach
                </div>
            @endif
        </div>
    </div>

    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    @foreach ($columns as $key => $column)
                        @if ($column['visible'])
                            <th scope="col"
                                class="{{ $column['class'] }} px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">
                                {{ $column['title'] }}
                            </th>
                        @endif
                    @endforeach
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach ($data as $row)
                    <tr @class([
                        'bg-gray-50' => $row['is_total_row'] ?? false,
                        'bg-blue-50' => $row['is_remittance_row'] ?? false,
                        'bg-purple-50' => $row['is_commission_row'] ?? false,
                    ])>
                        @foreach ($columns as $key => $column)
                            @if ($column['visible'])
                                <td class="{{ $column['class'] }} px-6 py-4 whitespace-nowrap text-sm">
                                    @if (str_ends_with($key, '_credit') || str_ends_with($key, '_debit'))
                                        {{ number_format($row[$key] ?? 0) }}
                                    @else
                                        {{ $row[$key] ?? '' }}
                                    @endif
                                </td>
                            @endif
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $data->links() }}
    </div>
</div>
