 <div>

     @if ($show == true)
         <!-- About User -->
         <div x-data="{ animate: false }" x-init="window.addEventListener('editForm', () => {
             animate = true;
             $refs.input.focus();
             $el.scrollIntoView({ behavior: 'smooth', block: 'center' });
             setTimeout(() => animate = false, 800);
         });" :class="{ 'pulse-focus': animate }"
             class="p-2 bg-white rounded-xl">
             <div class="card  mb-2">

                 <div class="card-body">
                     @if (auth()->user()->isAdmin())
                         <div class="d-flex justify-content-start mb-2">

                             <button class="btn btn-sm btn-outline-secondary"
                                 wire:click="$dispatch('openFormConfigModal', { formName: 'client_form' })">
                                 <i class="ti ti-settings"></i> إعداد الحقول
                             </button>
                         </div>
                     @endif
                     <p class="card-text text-uppercase">بطاقة الزبون</p>

                     <div class="row">
                         <div class="col-md-6">

                             <div class="form-check form-check-inline mt-3">
                                 <input class="form-check-input" type="radio" name="client_type" id="inlineRadio1"
                                     wire:model="client.type" value="1" />
                                 <label class="form-check-label" for="inlineRadio1">شخصي</label>
                             </div>

                             <div class="form-check form-check-inline mt-3">
                                 <input class="form-check-input" type="radio" name="client_type" id="inlineRadio2"
                                     wire:model="client.type" value="2" />
                                 <label class="form-check-label" for="inlineRadio2">شركة</label>
                             </div>
                         </div>
                         <div class="col-md-6">

                             <div class="form-check form-check-inline mt-3">
                                 <input class="form-check-input" type="radio" name="inlineRadioOptions1"
                                     id="inlineRadio3" value="male" checked wire:model="client.gender" />
                                 <label class="form-check-label" for="inlineRadio3">{{ __('client.male') }}</label>
                             </div>

                             <div class="form-check form-check-inline mt-3">
                                 <input class="form-check-input" type="radio" name="inlineRadioOptions1"
                                     id="inlineRadio4" value="female" wire:model="client.gender" />
                                 <label class="form-check-label" for="inlineRadio4">{{ __('client.female') }}</label>
                             </div>
                         </div>




                         <div class="col-md-6">
                             <label class="form-label"> {{ __('client.full_name') }} </label>
                             <input type="text" class="form-control" wire:model="client.name.ar" />
                             @error('client.name.ar')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror

                         </div>

                         <div class="col-md-6">
                             <label class="form-label"> {{ __('client.latin_name') }} </label>
                             <input type="text" class="form-control" wire:model="client.name.en" />
                             @error('client.name.en')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>

                         <div class="col-md-6">
                             <label class="form-label"> {{ __('client.birth_place') }}</label>
                             <input type="text" class="form-control" wire:model="client.place_of_birth" />
                             @error('client.place_of_birth')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>
                         <div class="col-md-6">
                             <label class="form-label"> {{ __('client.birth_date') }} </label>
                             <input type="date" class="form-control" wire:model.live="client.date_of_birth"
                                 id="date_of_birth" />
                             @error('client.date_of_birth')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>
                         <div class="col-md-6">
                             <label class="form-label">{{ __('client.father_name') }} </label>
                             <input type="text" class="form-control" wire:model="client.father_name" />
                             @error('client.father_name')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>

                         <div class="col-md-6">
                             <label class="form-label">{{ __('client.mother_name') }} </label>
                             <input type="text" class="form-control" wire:model="client.mother_name" />
                             @error('client.mother_name')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>




                         <div class="col-md-6 select2_content">
                             <label class="form-label"> {{ __('client.identity_type') }} </label>
                             <x-Mulk.select2 class="select2 form-select" data-allow-clear="true"
                                 wire:model="client.identity_type">
                                 @foreach ($identity_types as $identity_type)
                                     <option value="{{ $identity_type->id }}">{{ $identity_type->name }}</option>
                                 @endforeach

                             </x-Mulk.select2>
                             @error('client.identity_type')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>

                         <div class="col-md-6">
                             <label class="form-label"> {{ __('client.identity_number') }} </label>
                             <input type="text" class="form-control" wire:model="client.identity_number" />
                             @error('client.identity_number')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>
                         <div class="col-md-6">
                             <label class="form-label"> {{ __('client.nationality') }} </label>
                             <select class="select2 form-select" data-allow-clear="true"
                                 wire:model="client.nationality">
                                 @foreach ($countries as $country)
                                     <option value="{{ $country }}">{{ $country }}</option>
                                 @endforeach

                             </select>
                             @error('client.nationality')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>

                         <div class="col-md-6">
                             <label class="form-label"> {{ __('client.phone') }} </label>
                             <input type="text" class="form-control" wire:model="client.phone" />
                             @error('client.phone')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>

                         <div class="col-md-6">
                             <label class="form-label"> {{ __('client.mobile') }} </label>
                             <input type="text" class="form-control" wire:model="client.mobile" />
                             @error('client.mobile')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>



                         <div class="col-md-6">
                             <label class="form-label"> {{ __('client.job') }} </label>
                             <input type="text" class="form-control" wire:model="client.job" />
                             @error('client.job')
                                 <span class="text-danger">{{ $message }}</span>
                             @enderror
                         </div>
                         <div class="col-md-6 select2_content">
                             <label class="form-label"> {{ __('address.country') }} </label>
                             <x-Mulk.select2 class="form-select" wire:model="address.country">
                                 @foreach ($countries as $country)
                                     <option value="{{ $country }}">{{ $country }}</option>
                                 @endforeach
                             </x-Mulk.select2>

                         </div>
                         <div class="col-md-6">
                             <label class="form-label"> {{ __('address.city') }} </label>
                             <input type="text" class="form-control" wire:model="address.city" />
                         </div>
                         <div class="col-md-6">
                             <label class="form-label"> {{ __('address.state') }} </label>
                             <input type="text" class="form-control" wire:model="address.state" />
                         </div>
                         <div class="col-md-6">
                             <label class="form-label"> {{ __('address.neighborhood') }} </label>
                             <input type="text" class="form-control" wire:model="address.neighborhood" />
                         </div>
                         <div class="col-md-6">
                             <label class="form-label"> {{ __('address.street') }} </label>
                             <input type="text" class="form-control" wire:model="address.district" />
                         </div>
                         <div class="col-md-6">
                             <label class="form-label"> تفاصيل أخرى </label>
                             <input type="text" class="form-control" wire:model="client.details" />
                         </div>
                         @livewire('components.attachments-repeater')



                     </div>
                     <div class="   col-6 mx-auto mt-3">
                         <button class="btn btn-primary " type="button"
                             @if (isset($client['id'])) wire:click="ConfirmUpdate" @else wire:click="CreateClient" @endif>
                             @if (isset($client['id']))
                                 {{ __('update') }}
                             @else
                                 {{ __('create') }}
                             @endif
                         </button>
                         <button class="btn btn-secondary" type="button"
                             x-on:click="$dispatch('CancelAddClientEvent')">
                             {{ __('cancel') }}

                     </div>
                 </div>

             </div>
             <!--/ About User -->
         </div>
         <style>
             .pulse-focus {
                 animation: pulse 0.8s ease-out;
             }

             @keyframes pulse {
                 0% {
                     transform: scale(1.05);
                     box-shadow: 0 0 0 4px rgba(0, 102, 255, 0.4);
                 }

                 100% {
                     transform: scale(1);
                     box-shadow: none;
                 }
             }
         </style>
     @endif
 </div>
