<!-- Modal backdrop + container -->
<div class="modal fade" id="ClientDetailsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-simple  " wire:ignore.self>
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <!-- Personal Info Column -->
                    <div class="space-y-4">
                        <!-- Name -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-primary-100/20 text-primary-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-user"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">الاسم
                                    الكامل
                                </div>
                                <div class="text-gray-800 font-medium">{{ $client->name ?? '-' }}</div>
                            </div>
                        </div>

                        <!-- English Name -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-blue-100/20 text-blue-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-language"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">الاسم
                                    باللاتيني
                                </div>
                                <div class="text-gray-800 font-medium">{{ $client->name['en'] ?? '-' }}</div>
                            </div>
                        </div>

                        <!-- Birth Info -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-purple-100/20 text-purple-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-calendar-event"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">تاريخ
                                    الميلاد
                                </div>
                                <div class="text-gray-800">{{ $client->birth_date ?? '-' }}</div>
                            </div>
                        </div>

                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-amber-100/20 text-amber-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-map-pin"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">مكان
                                    الميلاد
                                </div>
                                <div class="text-gray-800">{{ $client->place_of_birth ?? '-' }}</div>
                            </div>
                        </div>

                        <!-- Gender -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-pink-100/20 text-pink-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-gender-bigender"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">الجنس</div>
                                <div class="text-gray-800">{{ ucfirst($client->gender ?? '-') }}</div>
                            </div>
                        </div>
                    </div>

                    <!-- ID & Contact Column -->
                    <div class="space-y-4">
                        <!-- ID Info -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-cyan-100/20 text-cyan-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-id"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">نوع الهوية
                                </div>
                                <div class="text-gray-800">{{ $client->identity_type_name ?? '-' }}</div>
                            </div>
                        </div>

                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-indigo-100/20 text-indigo-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-id-badge-2"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">رقم الهوية
                                </div>
                                <div class="text-gray-800 font-mono">{{ $client->identity_number ?? '-' }}</div>
                            </div>
                        </div>

                        <!-- Nationality -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-emerald-100/20 text-emerald-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-world"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">الجنسية
                                </div>
                                <div class="text-gray-800">{{ $client->nationality ?? '-' }}</div>
                            </div>
                        </div>

                        <!-- Contact -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-rose-100/20 text-rose-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-phone"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">الهاتف
                                </div>
                                <div class="text-gray-800">{{ $client->phone ?? '-' }}</div>
                            </div>
                        </div>

                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-green-100/20 text-green-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-device-mobile"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">الجوال
                                </div>
                                <div class="text-gray-800 font-medium">{{ $client->mobile ?? '-' }}</div>
                            </div>
                        </div>

                        <!-- Job -->
                        <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 flex items-start">
                            <div class="bg-orange-100/20 text-orange-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                                <i class="ti ti-briefcase"></i>
                            </div>
                            <div>
                                <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">الوظيفة
                                </div>
                                <div class="text-gray-800">{{ $client->job ?? '-' }}</div>
                            </div>
                        </div>
                    </div>

                    <!-- Full width sections -->
                    <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 md:col-span-2 flex items-start">
                        <div class="bg-violet-100/20 text-violet-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                            <i class="ti ti-map-2"></i>
                        </div>
                        <div class="flex-1">
                            <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">العنوان</div>
                            <div class="text-gray-800">
                                {{ $address->country ?? '-' }},
                                {{ $address->city ?? '-' }},
                                {{ $address->state ?? '-' }},
                                {{ $address->neighborhood ?? '-' }},
                                {{ $address->district ?? '-' }}
                            </div>
                        </div>
                    </div>

                    <!-- Attachments Section -->
                    <div class="bg-gray-50 p-4 rounded-lg border border-gray-100 md:col-span-2 flex items-start">
                        <div class="bg-gray-100/20 text-gray-600 p-2 rounded-lg mr-3 rtl:mr-0 rtl:ml-3">
                            <i class="ti ti-paperclip"></i>
                        </div>
                        <div class="flex-1">
                            <div class="text-xs font-medium text-gray-500 uppercase tracking-wider mb-1">المرفقات</div>
                            @if (count($mediaFiles) > 0)
                                @foreach ($mediaFiles as $collectionName => $files)
                                    <div class="mb-4">
                                        <div class="font-semibold text-gray-700 mb-2 pb-1 border-b border-gray-200">
                                            {{ $collectionName }}
                                        </div>
                                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                            @foreach ($files as $file)
                                                <div
                                                    class="bg-white p-3 rounded border border-gray-200 flex items-center">
                                                    <div class="text-primary-600 mr-3 rtl:mr-0 rtl:ml-3">
                                                        @if (str_contains($file['mime'], 'image/'))
                                                            <i class="ti ti-photo text-lg"></i>
                                                        @elseif(str_contains($file['mime'], 'application/pdf'))
                                                            <i class="ti ti-file-text text-lg"></i>
                                                        @else
                                                            <i class="ti ti-file text-lg"></i>
                                                        @endif
                                                    </div>
                                                    <div class="flex-1 min-w-0">
                                                        <div class="text-sm font-medium text-gray-800 truncate">
                                                            {{ $file['name'] }}
                                                        </div>
                                                        <div class="flex space-x-2 rtl:space-x-reverse mt-1">
                                                            <a href="{{ $file['url'] }}" target="_blank"
                                                                class="text-gray-500 hover:text-primary-600 text-sm"
                                                                title="عرض">
                                                                <i class="ti ti-eye"></i>
                                                            </a>
                                                            <a href="{{ $file['download'] }}" download
                                                                class="text-gray-500 hover:text-primary-600 text-sm"
                                                                title="تحميل">
                                                                <i class="ti ti-download"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="text-gray-500 italic">لا توجد مرفقات</div>
                            @endif
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<!-- End Modal backdrop + container -->
