<div>

    <div class="offcanvas offcanvas-end" id="FilterModal" aria-hidden="true" wire:ignore.self>
        <div class="offcanvas-header border-bottom">
            <h5 class="offcanvas-title">Filter </h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body flex-grow-1">

            <form>

                <div class="row">
                    @foreach ($filters as $field => $config)
                        @if (is_array($config) && $config['type'] == 'x-Mulk.select2')
                            <div class="col-sm-12 mb-3 select2_content">
                                <label class="form-label">{{ $field }}</label>
                                <x-Mulk.select2 wire:model="selectedFilters.{{ $config['key'] }}"
                                    name="{{ $config['key'] }}" :key="'{{ $field }}'" class="form-control">
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($config['options'] as $key => $label)
                                        <option value="{{ $key }}">
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </x-Mulk.select2>
                            </div>
                        @elseif (is_array($config) && $config['type'] == 'x-Mulk.select2_multiple')
                            <div class="col-sm-12 mb-3 select2_content">
                                <label class="form-label">{{ $config['key'] }}</label>
                                <x-Mulk.select2_multiple multiple wire:model="selectedFilters.{{ $config['key'] }}"
                                    name="{{ $config['key'] }}" :key="'{{ $field }}'" class="form-control">
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($config['options'] as $key => $label)
                                        <option value="{{ $key }}">
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </x-Mulk.select2_multiple>
                            </div>
                        @elseif (is_array($config) && $config['type'] == 'x-Mulk.range-operator')
                            <x-Mulk.operator-range :name="$config['key']" :label="$field" :operators="$config['options']['operators'] ?? []"
                                :filters="$selectedFilters" wire:key="operator-range-{{ $config['key'] }}" />
                        @elseif (is_array($config) && $config['type'] == 'date')
                            <div class="col-sm-12 mb-3">
                                <label class="form-label">{{ $field }}</label>
                                <x-Mulk.date class="form-control" wire:model="selectedFilters.{{ $config['key'] }}" />
                            </div>
                        @elseif (is_array($config) && $config['type'] == 'date-range')
                            <div class="col-sm-12 mb-3">
                                <label class="form-label">{{ $field }}</label>
                                <x-Mulk.date-range wire:model="selectedFilters.{{ $config['key'] }}"
                                    class="form-control" />
                            </div>
                        @elseif (is_array($config) && $config['type'] == 'switch')
                            <div class=" col-sm-12 mb-3 form-check form-switch mb-2">
                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckChecked"
                                    wire:model="selectedFilters.{{ $config['key'] }}" checked="">
                                <label class="form-check-label" for="flexSwitchCheckChecked"> {{ $field }}
                                </label>
                            </div>
                        @else
                            <div class="col-sm-12 mb-3">
                                <label class="form-label">{{ $field }}
                                </label>
                                <input type="text" class="form-control"
                                    wire:model="selectedFilters.{{ $config['key'] }}">
                            </div>
                        @endif
                    @endforeach


                </div>
                <div class="mb-6 d-flex flex-wrap">
                    <button type="button" class="btn btn-primary m-2 " wire:click="applyFilters"
                        wire:loading.attr="disabled"> <i class=" ti ti-search"></i>Apply</button>
                    <button type="button" class="btn btn-warning m-2  " wire:click="resetFilters"><i
                            class=" ti ti-refresh"></i>Reset</button>
                </div>
            </form>
        </div>
    </div>


























</div>
