<div wire:ignore>
    <div id="{{ $treeId }}"></div>
</div>

@stack('scripts')
<script>
    document.addEventListener('livewire:load', () => {
        const el = '#{{ $treeId }}';
        alert(el)
        $(el).jstree({
            core: {
                data: function(node, cb) {
                    window.livewire
                        .call('{{ $treeId }}.getChildren', node.id === '#' ? null : node.id)
                        .then(cb);
                },
                themes: {
                    stripes: true
                }
            },
            plugins: ['wholerow']
        });

        $(el).on('changed.jstree', function(e, data) {
            Livewire.emit('{{ $event }}', data.selected);
        });
    });
</script>
