<div class="d-flex justify-content-center align-items-center">
    <div class="p-3">
        @foreach ($wallets as $wallet)
            <div class="form-check custom-option custom-option-icon d-inline-block me-3">
                <label class="form-check-label custom-option-content" for="wallet_{{ $wallet->id }}"
                    data-bs-toggle="tooltip" data-bs-placement="top"
                    title="
                        <strong>Slug:</strong> {{ $wallet->slug }}<br>
                        <strong>Cari Code:</strong> {{ $wallet->cari_code ?? 'N/A' }}<br>
                        <strong>Currency:</strong> {{ $wallet->currency ?? 'USD' }}<br>
                      
                        <strong>Balance:</strong> {{ PriceFormat((float) $wallet->balance) }}
                    ">
                    <span class="custom-option-body">
                        <i class="ti ti-wallet ti-sm"></i> <!-- Wallet Icon -->
                        <span class="custom-option-title">
                            <div><span>{{ $wallet->name }}</span></div>
                            <span class="{{ $wallet->balance >= 0 ? 'text-success' : 'text-danger' }}">
                                Balance: {{ PriceFormat($wallet->balance) }}
                            </span>
                        </span>
                    </span>
                    <input name="wallet_id" wire:model.live="selected_wallet" class="form-check-input" type="radio"
                        value="{{ $wallet->id }}" id="wallet_{{ $wallet->id }}" />
                    <!-- Radio button for wallet selection -->
                </label>
            </div>
        @endforeach
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl, {
                    html: true, // Allow HTML content inside tooltip
                })
            })
        });
    </script>
</div>
