<div class="card h-100">
    <div class="card-header d-flex align-items-center justify-content-between">
        <div class="card-title mb-0">
            <h5 class="mb-1">{{ __('dashboard.transfers_graph') }}</h5>
        </div>
        <div class="d-flex gap-2">
            <!-- Transfer Type Filter -->
            <select wire:model.live="selectedTransferType" class="form-select form-select-sm" style="width: auto;">

                <option value="transfers">{{ __('Transfers') }}</option>
                <option value="approvals">{{ __('Approvals') }}</option>
                <option value="bookings">{{ __('Bookings') }}</option>
                <option value="exchanges">{{ __('Exchanges') }}</option>
            </select>

            <!-- Date Range Filter -->
            <select wire:model.live="selectedDateRange" class="form-select form-select-sm" style="width: auto;">
                <option value="7">{{ __('Last 7 Days') }}</option>
                <option value="10">{{ __('Last 10 Days') }}</option>
                <option value="30">{{ __('Last 30 Days') }}</option>
                <option value="90">{{ __('Last 90 Days') }}</option>
                <option value="year">{{ __('This Year') }}</option>
            </select>
        </div>
    </div>

    <!-- Custom Date Range Inputs -->
    @if ($selectedDateRange === 'custom')
        <div class="card-body border-bottom">
            <div class="row g-2">
                <div class="col-md-6">
                    <label class="form-label">{{ __('From Date') }}</label>
                    <input type="date" wire:model.live="dateFrom" class="form-control form-control-sm">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ __('To Date') }}</label>
                    <input type="date" wire:model.live="dateTo" class="form-control form-control-sm">
                </div>
            </div>
        </div>
    @endif

    <div class="card-body" wire:ignore>
        <div id="TransferLineChart"></div>
    </div>
</div>
