<div>

    @livewire('exchange.balance-reconciliation', ['type' => 'exchange'])

    <div class="row">
        <div class="col-xl-4 col-lg-4 col-md-4">
            <!-- About User -->
            <div class="card  mb-4">
                <div class="card-body">
                    <h4 class="card-text text-uppercase text-center"> سعر الصرف</h4>

                    <div class="card-body p-0">
                        @livewire('exchange.exchange-prices')
                    </div>

                </div>

            </div>


        </div>
        <div class="col-xl-4 col-lg-4 col-md-4">
            <div class="card  mb-4">
                <div class="card-body">
                    <form>
                        <div class="row">
                            <div class="col-md-4  ">
                                <label class="form-label"> </label>
                                {!! $this->currency_word !!}
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6  ">
                                <label class="form-label"> النوع </label>
                                <select class="select2 form-select" data-allow-clear="true" wire:model.live="type">
                                    <option value="buy">شراء - لنا</option>
                                    <option value="sell">بيع - علينا</option>
                                </select>
                            </div>


                            <div class="col-md-6  select2_content">
                                <label class="form-label"> العملة </label>
                                <x-Mulk.select2 class="  form-select" data-allow-clear="true"
                                    wire:model.live="currency">
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($currencies as $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                    @endforeach
                                </x-Mulk.select2>
                                @error('currency')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>





                            <div class="col-md-12 mt-3">
                                <label class="form-label">الرقم الوطني للزبون :</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="رقم الهويه أو جواز السفر"
                                        aria-describedby="button-addon2"
                                        wire:model="recipient.sender_identity_number" />
                                    <button class="btn btn-outline-primary" type="button" wire:click="searchClient"
                                        id="button-addon2">ابحث</button>
                                </div>
                                @error('recipient.sender_identity_number')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            @foreach ($items as $index => $item)
                                <div class="row d-flex align-items-end mt-3">
                                    <div class="col-md-4">
                                        <label class="form-label">العملة</label>
                                        <select wire:model.live="items.{{ $index }}.currency"
                                            class="form-select">
                                            <option value="">اختر</option>
                                            @foreach ($currencies as $currency)
                                                <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-4">
                                        <label class="form-label">المبلغ</label>
                                        <input type="number" wire:model.lazy="items.{{ $index }}.amount"
                                            class="form-control" />
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">المعامل</label>
                                        <select wire:model.live="items.{{ $index }}.factor"
                                            class="form-control" />
                                        <option value="multiply">ضرب</option>
                                        <option value="divide">قسمة</option>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">الصرف</label>
                                        <input type="number" wire:model.lazy="items.{{ $index }}.rate"
                                            class="form-control" />
                                    </div>

                                    <div class="col-md-2 mb-50">
                                        <label class="form-label d-block">&nbsp;</label>
                                        <button type="button" wire:click="removeItem({{ $index }})"
                                            class="btn btn-outline-danger">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </div>
                                    @error("items.$index.currency")
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>


                                <hr />
                            @endforeach

                            <div class="text-end mt-2">
                                <button type="button" wire:click="addItem" class="btn btn-outline-primary">
                                    <i class="fa fa-plus"></i> إضافة صف
                                </button>
                            </div>
                            <br />
                            @if ($canCreateExchange)
                                <div class="col-md-12 mt-5">
                                    <button class="btn btn-primary form-control" type="button"
                                        wire:loading.attr="disabled" wire:click="save">تنفيذ</button>
                                </div>
                            @else
                                <div class="col-md-12 mt-5">
                                    <div class="alert alert-danger text-center">
                                        {{ $createExchangeMessage ?: 'غير مسموح لك بتنفيذ التحويل حالياً' }}
                                    </div>
                                </div>
                            @endif



                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-4">
            @livewire('client.add')
        </div>

        <style>
            .clickable-strong {
                cursor: pointer;
                transition: transform 0.2s, color 0.2s;
                display: inline-block;
                color: black;
            }

            .clickable-strong:hover {
                color: #007bff;
                /* blue on hover */
                transform: scale(1.1);
                /* slight zoom */
            }
        </style>






    </div>
