@php
    $hasChildren = isset($children[$account['ledgerUuid']]) && count($children[$account['ledgerUuid']]) > 0;
    $names = $account['names'] ?? [];
    $accountName = $this->getName($names);
@endphp

<li class="mb-2">
    <div class="flex items-center space-x-3">
        {{-- Expand / Collapse Button --}}
        <button wire:click="loadChildren('{{ $account['ledgerUuid'] }}')"
            class="w-6 h-6 flex items-center justify-center text-gray-600 hover:text-blue-600"
            title="{{ $hasChildren ? 'Collapse/Expand' : 'Load Children' }}">
            @if (isset($expanded[$account['ledgerUuid']]))
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4" />
                </svg>
            @else
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                </svg>
            @endif
        </button>

        {{-- Account Info --}}
        <div class="flex-grow">
            <span class="font-semibold">{{ $account['code'] }}</span> -
            <span>{{ $accountName }}</span>

            @if (!empty($account['extra']['agent_id'] ?? null))
                <span class="ml-2 text-green-600">(Agent ID: {{ $account['extra']['agent_id'] }})</span>
            @endif
        </div>

        {{-- Action Buttons --}}
        <div class="flex space-x-1">
            <button wire:click="$emit('openAddModal', '{{ $account['ledgerUuid'] }}')"
                class="text-blue-600 hover:text-blue-800" title="Add Child">
                + Add
            </button>
            <button wire:click="$emit('openEditModal', '{{ $account['ledgerUuid'] }}')"
                class="text-yellow-600 hover:text-yellow-800" title="Edit">
                ✎ Edit
            </button>
            <button wire:click="$emit('openDeleteModal', '{{ $account['ledgerUuid'] }}')"
                class="text-red-600 hover:text-red-800" title="Delete">
                ✗ Delete
            </button>
        </div>
    </div>

    {{-- Recursive children --}}
    @if (isset($children[$account['ledgerUuid']]))
        <ul class="ml-8 mt-2 border-l border-gray-300 pl-4">
            @foreach ($children[$account['ledgerUuid']] as $child)
                @include('livewire.partials.account-node', ['account' => $child, 'children' => $children])
            @endforeach
        </ul>
    @endif
</li>
