<li class="group relative transition-all duration-200">
    <!-- Vertical connector line with gradient -->
    <div
        class="absolute left-5 top-0 bottom-0 w-0.5 bg-gradient-to-b from-primary/10 via-primary/20 to-primary/10 transform -translate-x-1/2 z-0">
    </div>

    <div class="relative z-10">
        <!-- Enhanced card-like background with subtle effects -->
        <div
            class="flex items-center p-3 rounded-lg transition-all duration-200
                   bg-white border border-gray-100 hover:border-primary/20
                   shadow-xs hover:shadow-sm group-[.is-expanded]:bg-gray-50/50
                   group-[.is-expanded]:border-primary/30">

            <!-- Expand/Collapse Button with improved styling -->
            <div class="mr-3 rtl:mr-0 rtl:ml-3 flex items-center h-8">
                @php
                    $hasChildren = \App\Models\CustomLedgerAccount::where('parentUuid', $account->ledgerUuid)->exists();
                    $childrenCount = \App\Models\CustomLedgerAccount::where(
                        'parentUuid',
                        $account->ledgerUuid,
                    )->count();
                @endphp

                @if ($hasChildren)
                    <button wire:click="toggle"
                        class="flex items-center justify-center w-7 h-7 rounded-full
                               bg-gradient-to-br from-primary/10 to-primary/20
                               text-primary hover:from-primary/20 hover:to-primary/30
                               shadow-inner transition-all duration-200">
                        @if ($expanded)
                            <i class="ti ti-folder-open text-sm"></i>
                        @else
                            <i class="ti ti-folder text-sm"></i>
                        @endif
                    </button>
                @else
                    <div class="w-7 h-7 flex items-center justify-center rounded-full bg-gray-50/80">
                        <i class="ti ti-file text-sm text-gray-500"></i>
                    </div>
                @endif
            </div>

            <!-- Account Info with enhanced typography -->
            <div class="flex-grow flex items-center min-w-0">
                <div class="min-w-0">
                    <div class="flex items-center space-x-2.5 rtl:space-x-reverse">
                        <span
                            class="inline-flex items-center justify-center px-2.5 py-1 text-xs font-semibold
                                  leading-none rounded-full bg-gradient-to-r from-primary/10 to-primary/20
                                  text-primary border border-primary/20 shadow-xs">
                            {{ $account->code }}
                        </span>
                        <span class="font-medium text-gray-800 truncate">
                            {{ $account->names->firstWhere('language', app()->getLocale())->name ?? 'بدون اسم' }}
                        </span>
                    </div>
                    @if ($hasChildren)
                        <div class="text-xs text-gray-500 mt-1 flex items-center">
                            <i class="ti ti-folders mr-1.5 rtl:mr-0 rtl:ml-1.5 text-xs"></i>
                            {{ $childrenCount }} {{ $childrenCount == 1 ? 'عنصر' : 'عناصر' }} فرعية
                        </div>
                    @endif
                </div>
            </div>

            <!-- Action Buttons with refined styling -->
            <div class="flex items-center space-x-1.5 rtl:space-x-reverse ml-3">
                <button
                    class="btn btn-icon btn-sm btn-outline-secondary hover:bg-secondary/10
                              hover:shadow-xs transition-all duration-200"
                    wire:click="editAccount('{{ $account->ledgerUuid }}')" data-bs-toggle="tooltip"
                    data-bs-placement="top" title="تعديل">
                    <i class="ti ti-edit text-sm"></i>
                </button>
                <button
                    class="btn btn-icon btn-sm btn-outline-danger hover:bg-danger/10
                              hover:shadow-xs transition-all duration-200"
                    wire:click="deleteAccount('{{ $account->ledgerUuid }}')" data-bs-toggle="tooltip"
                    data-bs-placement="top" title="حذف">
                    <i class="ti ti-trash text-sm"></i>
                </button>
                <button
                    class="btn btn-icon btn-sm bg-primary/10 hover:bg-primary/20
                              text-primary hover:text-white border border-primary/20
                              hover:border-primary/50 hover:shadow-xs transition-all duration-200"
                    wire:click="addChildAccount('{{ $account->ledgerUuid }}')" data-bs-toggle="tooltip"
                    data-bs-placement="top" title="إضافة فرعي">
                    <i class="ti ti-plus text-sm"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Children with enhanced background -->
    @if ($expanded && count($children) > 0)
        <ul class="pl-8 relative mt-1.5">
            <!-- Horizontal connector line with gradient -->
            <div class="absolute left-5 top-0 w-3 h-px bg-gradient-to-r from-primary/10 to-primary/20"></div>
            @foreach ($children as $child)
                @livewire('ledger.account-tree-node', ['account' => $child], key($child->ledgerUuid))
            @endforeach
        </ul>
    @endif
</li>
